/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.AuroraIDocException;
import aurora.plugin.sap.sync.idoc.IDocServer;
import aurora.plugin.sap.sync.idoc.LoggerUtil;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.sql.DataSource;
import uncertain.core.IGlobalInstance;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class IDocServerInstance
implements IGlobalInstance {
    public static final String PLUGIN = "aurora.plugin.sap.sync.idoc";
    public static final String SEPARATOR = ",";
    public String DeleteImmediately = "Y";
    public String INTERFACE_HISTORY_FLAG = "Y";
    public String SERVER_NAME_LIST;
    public String IDOC_DIR;
    public String RECONNECT_TIME = "60000";
    public String MAX_RECONNECT_TIME = "3600000";
    private List serverList;
    private IObjectRegistry registry;
    private String version = "1.4";

    public IDocServerInstance(IObjectRegistry registry) {
        this.registry = registry;
        this.serverList = new LinkedList();
    }

    public void onInitialize() throws Exception {
        this.initLoggerUtil();
        this.run();
        Runnable shutdownHook = new Runnable(){

            @Override
            public void run() {
                try {
                    IDocServerInstance.this.onShutdown();
                    System.out.println("shutdown idoc finished!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutdownHook));
    }

    private void initLoggerUtil() {
        ILogger logger = LoggingContext.getLogger((String)PLUGIN, (IObjectRegistry)this.registry);
        if (logger == null) {
            throw new RuntimeException("Can not get logger from registry!");
        }
        LoggerUtil.setLogger(logger);
    }

    public void onShutdown() throws Exception {
        if (this.serverList != null && !this.serverList.isEmpty()) {
            for (IDocServer server : this.serverList) {
                server.setShutdownByCommand(true);
                server.shutdown();
            }
            this.serverList = null;
        }
    }

    public void run() throws AuroraIDocException {
        LoggerUtil.getLogger().info("Aurora IDoc Plugin version: " + this.version);
        LoggerUtil.getLogger().info("IDoc Dir:" + this.IDOC_DIR);
        if (this.IDOC_DIR == null || "".equals(this.IDOC_DIR)) {
            throw new IllegalArgumentException("IDOC_DIR can not be null !");
        }
        File file = new File(this.IDOC_DIR);
        if (!file.exists()) {
            throw new IllegalArgumentException("IDOC_DIR:" + this.IDOC_DIR + " is not exists!");
        }
        LoggerUtil.getLogger().info("Server name list:" + this.SERVER_NAME_LIST);
        if (this.SERVER_NAME_LIST == null || this.SERVER_NAME_LIST.equals("")) {
            throw new IllegalArgumentException("SERVER_NAME_LIST can not be null !");
        }
        int reconnectTime = Integer.parseInt(this.RECONNECT_TIME);
        int maxReconnectTime = Integer.parseInt(this.MAX_RECONNECT_TIME);
        String[] servers = this.SERVER_NAME_LIST.split(SEPARATOR);
        DataSource ds = (DataSource)this.registry.getInstanceOfType(DataSource.class);
        if (ds == null) {
            throw new AuroraIDocException("Can not get DataSource from registry " + this.registry);
        }
        for (int i = 0; i < servers.length; ++i) {
            String serverName = servers[i];
            try {
                IDocServer server = new IDocServer(this.IDOC_DIR, ds, serverName, this.isDeleteFileImmediately(), this.isEnableInterfaceHistory(), reconnectTime, maxReconnectTime);
                server.start();
                this.serverList.add(server);
                continue;
            }
            catch (Throwable e) {
                LoggerUtil.getLogger().log(Level.SEVERE, "start server " + serverName + " failed!", e);
            }
        }
    }

    public boolean isDeleteFileImmediately() {
        return "Y".equals(this.DeleteImmediately);
    }

    public boolean isEnableInterfaceHistory() {
        return "Y".equals(this.INTERFACE_HISTORY_FLAG);
    }
}

