/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.memcached;

import aurora.plugin.memcached.MemcachedClientWrapper;
import java.util.logging.Level;
import net.rubyeye.xmemcached.MemcachedClient;
import org.apache.commons.codec.digest.DigestUtils;
import uncertain.logging.DummyLogger;
import uncertain.logging.ILogger;

public class XmemcachedClientWrapper
extends MemcachedClientWrapper {
    String mName;
    MemcachedClient mClient;
    long mTimeout = 100L;
    ILogger mLogger = DummyLogger.getInstance();

    private XmemcachedClientWrapper(String name, net.spy.memcached.MemcachedClient client) {
        super(name, client);
    }

    public XmemcachedClientWrapper(String name, MemcachedClient client) {
        super(null, null);
        this.mClient = client;
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public long getTimeout() {
        return this.mTimeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    @Override
    public ILogger getLogger() {
        return this.mLogger;
    }

    @Override
    public void setLogger(ILogger logger) {
        this.mLogger = logger;
    }

    @Override
    public Object getValue(Object key) {
        this.checkKey(key);
        key = DigestUtils.md5Hex((String)key.toString());
        try {
            return this.mClient.get(key.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean setValue(Object key, Object value) {
        return this.setValue(key, 0, value);
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
    }

    @Override
    public boolean setValue(Object key, int timeout, Object value) {
        this.checkKey(key);
        key = DigestUtils.md5Hex((String)key.toString());
        try {
            return this.mClient.set(key.toString(), timeout, value);
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "Error when trying to set value to memcached server", (Throwable)e);
            return false;
        }
    }

    @Override
    public void remove(Object key) {
        this.checkKey(key);
        key = DigestUtils.md5Hex((String)key.toString());
        try {
            this.mClient.delete(key.toString());
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "Error when removing key " + key + " from memcached server", (Throwable)e);
        }
    }

    @Override
    public void clear() {
        try {
            this.mClient.flushAll();
        }
        catch (Exception e) {
            this.mLogger.log(Level.WARNING, "Error when do flushAll on memcached server", (Throwable)e);
        }
    }
}

