/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.export;

import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import aurora.plugin.poi.ExcelExportImpl;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class ModelOutput {
    public static final String KEY_COLUMN_CONFIG = "_column_config_";
    public static final String KEY_FILE_NAME = "_file_name_";
    public static final String KEY_CHARSET = "GBK";
    public static final String KEY_PROMPT = "prompt";
    public static final String KEY_DATA_INDEX = "name";
    public static final String KEY_MERGE_COLUMN = "_merge_column_";
    public static final String KEY_COLUMN = "column";
    public static final String KEY_WIDTH = "width";
    public static final String KEY_GENERATE_STATE = "_generate_state";
    public static final String KEY_FORMAT = "_format";
    public static final String KEY_SEPARATOR = "separator";
    IObjectRegistry mObjectRegistry;
    int modelQueryTagNum;

    public ModelOutput(IObjectRegistry registry) {
        this.mObjectRegistry = registry;
    }

    public int preInvokeService(ServiceContext context) throws Exception {
        CompositeMap parameters = context.getParameter();
        if (!parameters.getBoolean((Object)KEY_GENERATE_STATE, false)) {
            return 0;
        }
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        CompositeMap config = svc.getServiceConfigData().getChild("init-procedure");
        if (config == null) {
            mLogger.log(Level.SEVERE, "init-procedure tag must be defined");
            throw new ServletException("init-procedure tag must be defined");
        }
        String return_path = (String)svc.getServiceConfigData().getObject("service-output/@output");
        if (return_path == null) {
            mLogger.log(Level.SEVERE, "service-output tag must be defined");
            throw new ServletException("service-output tag must be defined");
        }
        if (!return_path.startsWith("/")) {
            return_path = "/" + return_path;
        }
        this.modelQueryTagNum = 0;
        if (this.createConsumerTag(config, return_path, parameters) && this.modelQueryTagNum == 0) {
            mLogger.log(Level.SEVERE, "The path '" + return_path + "' can't find model-query tag");
            throw new ServletException("The path '" + return_path + "' can't find model-query tag");
        }
        return 0;
    }

    boolean createConsumerTag(CompositeMap actionConfig, String return_path, CompositeMap parameters) {
        if (this.modelQueryTagNum != 0) {
            return true;
        }
        Iterator iterator = actionConfig.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext() && !this.createConsumerTag((CompositeMap)iterator.next(), return_path, parameters)) {
            }
        } else {
            String rootpath = actionConfig.getString((Object)"rootpath");
            if (rootpath != null) {
                if (!rootpath.startsWith("/")) {
                    rootpath = "/model/" + rootpath;
                }
                if ("model-query".equals(actionConfig.getName()) && return_path.equalsIgnoreCase(rootpath)) {
                    actionConfig.putBoolean((Object)"fetchall", true);
                    String format = parameters.getString((Object)KEY_FORMAT);
                    if ("xlsx".equals(format)) {
                        actionConfig.createChildByTag("consumer").createChildByTag("output-excel").setNameSpaceURI("http://www.aurora-framework.org/application");
                        ++this.modelQueryTagNum;
                        return true;
                    }
                    if ("txt".equals(format)) {
                        actionConfig.createChildByTag("consumer").createChildByTag("output-txt").setNameSpaceURI("http://www.aurora-framework.org/application");
                        ++this.modelQueryTagNum;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int preCreateSuccessResponse(ServiceContext context) throws Exception {
        CompositeMap parameter = context.getParameter();
        if (!parameter.getBoolean((Object)KEY_GENERATE_STATE, false)) {
            return 0;
        }
        if (!"xls".equals(parameter.getString((Object)KEY_FORMAT))) {
            return 2;
        }
        IMessageProvider msgProvider = (IMessageProvider)this.mObjectRegistry.getInstanceOfType(IMessageProvider.class);
        String langString = context.getSession().getString((Object)"lang", "ZHS");
        ILocalizedMessageProvider localMsgProvider = msgProvider.getLocalizedMessageProvider(langString);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        HttpServletResponse response = ((HttpServiceInstance)svc).getResponse();
        String fileName = parameter.getString((Object)KEY_FILE_NAME, "excel");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(KEY_CHARSET);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes(), "ISO-8859-1") + ".xls\"");
        ExcelExportImpl excelFactory = new ExcelExportImpl(localMsgProvider);
        excelFactory.createExcel(this.getExportData(context), this.getColumnConfig(context), (OutputStream)response.getOutputStream(), context.getParameter().getChild(KEY_MERGE_COLUMN));
        return 2;
    }

    CompositeMap getExportData(ServiceContext context) throws ServletException {
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        String return_path = (String)svc.getServiceConfigData().getObject("service-output/@output");
        if (return_path == null) {
            mLogger.log(Level.SEVERE, "service-output must be defined");
            throw new ServletException("service-output must be defined");
        }
        CompositeMap exportData = (CompositeMap)context.getObjectContext().getObject(return_path);
        return exportData;
    }

    CompositeMap getColumnConfig(ServiceContext context) throws ServletException {
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        CompositeMap column_config = (CompositeMap)context.getParameter().getObject("_column_config_/column");
        if (column_config == null) {
            mLogger.log(Level.SEVERE, "_column_config_ tag and column attibute must be defined");
            throw new ServletException("_column_config_ tag and column attibute must be defined");
        }
        return column_config;
    }
}

