/*
 * Decompiled with CFR 0.152.
 */
package uncertain.exception;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import uncertain.exception.GeneralException;
import uncertain.exception.ICodedException;
import uncertain.proc.trace.IWithProcedureStackTrace;
import uncertain.proc.trace.TraceElement;
import uncertain.util.resource.ILocatable;
import uncertain.util.resource.Location;

public class MessageFactory {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String RESOURCES_UNCERTAIN_BUILTIN_EXCEPTIONS = "resources.UncertainBuiltinExceptions";
    public static final String DEFAULT_EXCEPTION_CONFIG_FILE_NAME = "exception_config";
    private static Locale locale = Locale.getDefault();
    private static Map messages = new HashMap();
    private static Map loaded_paths = new HashMap();
    public static final String KEY_UNCERTAIN_EXCEPTION_SOURCE_FILE = "uncertain.exception.source_file";

    public static synchronized void loadResource(String path) {
        MessageFactory.loadResource(path, locale);
    }

    public static synchronized void loadResourceByPackage(String pkg_name) {
        String path = pkg_name + '.' + DEFAULT_EXCEPTION_CONFIG_FILE_NAME;
        MessageFactory.loadResource(path);
    }

    public static void loadResource(String path, Locale locale) {
        MessageFactory.loadResource(path, locale, false);
    }

    public static void loadResource(String path, boolean overwrite) {
        MessageFactory.loadResource(path, locale, overwrite);
    }

    public static void loadResource(String path, Locale locale, boolean overwrite) {
        ResourceBundle resourceBundle = null;
        resourceBundle = ResourceBundle.getBundle(path, locale);
        if (loaded_paths.containsKey(path) && !overwrite) {
            return;
        }
        loaded_paths.put(path, path);
        if (resourceBundle == null) {
            throw new RuntimeException("Can't load resource " + path);
        }
        Enumeration<String> keys = resourceBundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String fullKey = MessageFactory.generateFullKey(key, locale);
            if (messages.containsKey(fullKey) && !overwrite) {
                throw new RuntimeException("The key:" + key + " from " + path + " has been defined before ! Please try another.");
            }
            messages.put(fullKey, resourceBundle.getString(key));
        }
    }

    public static GeneralException createException(String message_code, Throwable cause) {
        return MessageFactory.createException(message_code, cause, null);
    }

    public static GeneralException createException(String message_code, Throwable cause, Object[] args) {
        return new GeneralException(message_code, args, cause);
    }

    public static GeneralException createException(String message_code, Throwable cause, Object[] args, ILocatable source) {
        return new GeneralException(message_code, args, cause, source);
    }

    public static String getMessage(String msg_code, Locale locale, Object[] args) {
        String fullKey = MessageFactory.generateFullKey(msg_code, locale);
        Object message_obj = messages.get(fullKey);
        if (message_obj == null) {
            return msg_code;
        }
        return MessageFormat.format((String)message_obj, args);
    }

    public static String getMessage(String msg_code, Object[] args) {
        return MessageFactory.getMessage(msg_code, locale, args);
    }

    public static String generateFullKey(String msg_code, Locale locale) {
        if (msg_code == null || locale == null) {
            return null;
        }
        return msg_code + locale.getLanguage();
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale locale) {
        MessageFactory.locale = locale;
    }

    public static String getLocationMessage(String source, int line, int row) {
        return MessageFactory.getMessage(KEY_UNCERTAIN_EXCEPTION_SOURCE_FILE, new Object[]{source, new Integer(line), new Integer(row)});
    }

    public static String getLocationMessage(ILocatable locate) {
        Location l = locate.getOriginLocation();
        if (l != null && locate.getOriginSource() != null) {
            return MessageFactory.getLocationMessage(locate.getOriginSource(), l.getStartLine(), l.getStartColumn());
        }
        if (locate.getOriginSource() != null) {
            return MessageFactory.getLocationMessage(locate.getOriginSource(), 0, 0);
        }
        return "";
    }

    public static String getExceptionMessage(Throwable exp, String origin_message) {
        TraceElement element;
        ILocatable lcb;
        ICodedException cexp;
        String code;
        StringBuffer result = new StringBuffer();
        if (exp instanceof ICodedException && (code = (cexp = (ICodedException)((Object)exp)).getCode()) != null) {
            result.append(MessageFactory.getMessage("uncertain.exception.code", new Object[]{code}));
        }
        if (exp instanceof ILocatable && (lcb = (ILocatable)((Object)exp)) != null) {
            result.append(MessageFactory.getLocationMessage(lcb));
        }
        result.append(origin_message);
        if (exp instanceof IWithProcedureStackTrace && (element = ((IWithProcedureStackTrace)((Object)exp)).getTraceElement()) != null) {
            String trace = element.toStackTrace();
            result.append(LINE_SEPARATOR).append(trace);
        }
        return result.toString();
    }

    static {
        MessageFactory.loadResource(RESOURCES_UNCERTAIN_BUILTIN_EXCEPTIONS);
    }
}

