/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import uncertain.composite.CompositeMap;

public class DynamicObject {
    protected CompositeMap object_context;

    public static Object cast(CompositeMap context, Class inst_class) {
        if (context == null) {
            return null;
        }
        try {
            return ((DynamicObject)inst_class.newInstance()).initialize(context);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create instance of " + inst_class.getName(), ex);
        }
    }

    public static DynamicObject[] castToArray(Collection records, Class inst_class) {
        if (inst_class.isAssignableFrom(DynamicObject.class)) {
            throw new IllegalArgumentException("class " + inst_class.getName() + " is not sub class of DynamicObject");
        }
        try {
            DynamicObject[] array = (DynamicObject[])Array.newInstance(inst_class, records.size());
            int id = 0;
            for (CompositeMap record : records) {
                DynamicObject obj = (DynamicObject)inst_class.newInstance();
                obj.initialize(record);
                array[id++] = obj;
            }
            return array;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create array instance of " + inst_class.getName(), ex);
        }
    }

    public DynamicObject initialize(CompositeMap context) {
        this.object_context = context;
        return this;
    }

    public DynamicObject initialize() {
        this.object_context = new CompositeMap(30);
        return this;
    }

    public CompositeMap getObjectContext() {
        return this.object_context;
    }

    public Object castTo(Class new_class) {
        return DynamicObject.cast(this.getObjectContext(), new_class);
    }

    public Object get(Object key) {
        if (this.object_context == null) {
            throw new IllegalStateException("Object context not initialized");
        }
        return this.object_context.get(key);
    }

    public void put(Object key, Object value) {
        this.object_context.put(key, value);
    }

    public String getString(String key) {
        return this.getObjectContext().getString(key);
    }

    public String getString(String key, String default_value) {
        return this.getObjectContext().getString(key, default_value);
    }

    public Boolean getBoolean(String key) {
        return this.getObjectContext().getBoolean(key);
    }

    public boolean getBoolean(String key, boolean default_value) {
        return this.getObjectContext().getBoolean(key, default_value);
    }

    public Integer getInteger(String key) {
        return this.getObjectContext().getInt(key);
    }

    public int getInt(String key, int default_value) {
        return this.getObjectContext().getInt(key, default_value);
    }

    public Long getLong(String key) {
        return this.getObjectContext().getLong(key);
    }

    public long getLong(String key, int default_value) {
        return this.getObjectContext().getLong(key, default_value);
    }

    public void putString(String key, String value) {
        this.getObjectContext().put(key, value);
    }

    public void putInt(String key, int value) {
        this.getObjectContext().put(key, new Integer(value));
    }

    public void putLong(String key, long value) {
        this.getObjectContext().put(key, new Long(value));
    }

    public void putBoolean(String key, boolean value) {
        this.getObjectContext().put(key, (Object)value);
    }

    public void checkValidation() {
    }

    public List getChilds(String name) {
        CompositeMap child = this.object_context.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getChilds();
    }

    public CompositeMap getChildNotNull(String name_space, String name) {
        CompositeMap child = this.object_context.getChild(name);
        if (child == null) {
            child = this.object_context.createChild(name);
            child.setNameSpace(null, name_space);
        }
        return child;
    }
}

