/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.ToolBarButton;
import java.io.IOException;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.composite.TextParser;

public class GridButton
extends ToolBarButton {
    public static final String VERSION = "$Revision: 6975 $";
    public static final String TAG_NAME = "gridButton";
    private static final String PROPERTITY_TYPE = "type";
    private static final String PROPERTITY_BIND = "bind";

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        List list;
        CompositeMap model = context.getModel();
        CompositeMap view = context.getView();
        String type = view.getString(PROPERTITY_TYPE, "");
        String grid = view.getString(PROPERTITY_BIND, "");
        if (!"".equals(type) && !"".equals(grid) && (list = CompositeUtil.findChilds(view.getRoot(), "grid", "id", grid)) != null && list.size() == 1) {
            CompositeMap gc = (CompositeMap)list.get(0);
            String dataset = TextParser.parse(gc.getString("bindtarget", ""), model);
            String id = view.getString("id", "");
            if ("".equals(id)) {
                id = grid + "_" + type;
                view.putString("id", id);
            }
            String fileName = view.getString("filename", "");
            if ("add".equalsIgnoreCase(type)) {
                view = this.createButton(view, session.getLocalizedPrompt("HAP_NEW"), "grid-add2", "background-position:0px 3px;", "function(){$('" + grid + "').showEditorByRecord($('" + dataset + "').create())}");
            } else if ("delete".equalsIgnoreCase(type)) {
                view = this.createButton(view, session.getLocalizedPrompt("HAP_DELETE"), "grid-delete2", "background-position:0px -22px;", "function(){$('" + grid + "').remove()}");
            } else if ("save".equalsIgnoreCase(type)) {
                view = this.createButton(view, session.getLocalizedPrompt("HAP_SAVE"), "grid-save2", "background-position:0px -73px;", "function(){$('" + dataset + "').submit()}");
            } else if ("clear".equalsIgnoreCase(type)) {
                view = this.createButton(view, session.getLocalizedPrompt("HAP_CLEAR"), "grid-clear2", "background-position:0px -47px;", "function(){$('" + grid + "').clear()}");
            } else if ("excel".equalsIgnoreCase(type)) {
                view = this.createButton(view, session.getLocalizedPrompt("HAP_EXPORT"), "grid-excel2", "background-position:0px -122px;", "function(){$('" + grid + "')._export('xls','" + fileName + "')}");
            } else if ("excel2007".equalsIgnoreCase(type)) {
                view = this.createButton(view, session.getLocalizedPrompt("HAP_EXPORT"), "grid-excel2", "background-position:0px -175px;", "function(){$('" + grid + "')._export('xlsx','" + fileName + "')}");
            } else if ("txt".equalsIgnoreCase(type)) {
                String separator = view.getString("separator", "");
                view = this.createButton(view, session.getLocalizedPrompt("HAP_EXPORT"), "grid-excel2", "background-position:0px -149px;", "function(){$('" + grid + "')._export('txt','" + fileName + "','" + separator + "')}");
            } else if ("customize".equalsIgnoreCase(type)) {
                view = this.createButton(view, session.getLocalizedPrompt("HAP_CUST"), "grid-cust2", "background-position:0px -98px;", "function(){$('" + grid + "').customize()}");
            }
        }
        super.onCreateViewContent(session, context);
    }

    private CompositeMap createButton(CompositeMap button, String text, String clz, String style, String function) {
        if ("".equals(button.getString("icon", ""))) {
            button.put("icon", "null");
            button.put("btnclass", clz);
            button.put("btnstyle", style);
        }
        button.put("text", button.getString("text", text));
        if (!"".equals(function)) {
            button.put("click", function);
        }
        return button;
    }
}

