/*
 * Decompiled with CFR 0.152.
 */
package aurora.i18n;

import aurora.i18n.CacheBasedMessageProvider;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.service.ServiceThreadLocal;
import java.text.MessageFormat;
import uncertain.composite.TextParser;

public class CacheBasedLocalizedMessageProvider
implements ILocalizedMessageProvider {
    private String lang;
    private String cacheKey = "{0}.{1}";
    private CacheBasedMessageProvider messageProvider;

    public CacheBasedLocalizedMessageProvider(String language_code, CacheBasedMessageProvider messageProvider) {
        this.lang = language_code;
        this.messageProvider = messageProvider;
    }

    @Override
    public String getMessage(String code) {
        return this.messageProvider.getMessage(this.lang, code);
    }

    @Override
    public String getMessage(String code, Object[] params) {
        return this.messageProvider.getMessage(this.lang, code, params);
    }

    @Override
    public void putMessage(String code, String description) {
        this.messageProvider.setMessage(this.lang, code, description);
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        return this.lang;
    }

    public String getKey(String code) {
        String patten = TextParser.parse(this.cacheKey, ServiceThreadLocal.getCurrentThreadContext());
        return MessageFormat.format(patten, code, this.lang);
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }
}

