/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.CheckBoxConfig;
import aurora.presentation.component.std.config.ComboBoxConfig;
import aurora.presentation.component.std.config.ComponentConfig;
import aurora.presentation.component.std.config.DatePickerConfig;
import aurora.presentation.component.std.config.GridColumnConfig;
import aurora.presentation.component.std.config.GridConfig;
import aurora.presentation.component.std.config.LovConfig;
import aurora.presentation.component.std.config.NumberFieldConfig;
import aurora.presentation.component.std.config.TextFieldConfig;
import aurora.service.ServiceContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.event.Configuration;
import uncertain.proc.IFeature;
import uncertain.proc.ProcedureRunner;

public class AutoGrid
implements IFeature {
    private static final String PROPERTITY_MODEL = "model";
    IDatabaseServiceFactory mFactory;
    CompositeMap view;

    public AutoGrid(IDatabaseServiceFactory factory) {
        this.mFactory = factory;
    }

    public int onCreateView(ProcedureRunner runner) throws IOException {
        ServiceContext sc = ServiceContext.createServiceContext(runner.getContext());
        CompositeMap model = sc.getModel();
        CompositeMap gridView = this.processColumns(model);
        gridView = this.processEditors(gridView);
        this.view.getParent().replaceChild(this.view, gridView);
        return 0;
    }

    private CompositeMap processEditors(CompositeMap gv) throws IOException {
        List list;
        GridConfig grid = GridConfig.getInstance(gv);
        CompositeMap columns = grid.getColumns();
        if (columns != null && (list = columns.getChilds()) != null) {
            for (CompositeMap column : list) {
                ComponentConfig editor;
                GridColumnConfig cf = GridColumnConfig.getInstance(column);
                String eid = cf.getEditor();
                if (eid != null && !"".equals(eid) || (editor = this.getEditor(column)) == null) continue;
                grid.addEditor(editor);
                cf.setEditor(editor.getId());
                column.getParent().replaceChild(column, cf.getObjectContext());
            }
        }
        CompositeMap gridView = grid.getObjectContext();
        return gridView;
    }

    private ComponentConfig getEditor(CompositeMap column) {
        String type = column.getString("editortype", "");
        if ("".equals(type)) {
            return null;
        }
        if ("checkbox".equalsIgnoreCase(type)) {
            CheckBoxConfig checkbox = CheckBoxConfig.getInstance();
            checkbox.setId(IDGenerator.getInstance().generate());
            return checkbox;
        }
        if ("textfield".equalsIgnoreCase(type)) {
            TextFieldConfig textfield = TextFieldConfig.getInstance();
            textfield.setId(IDGenerator.getInstance().generate());
            return textfield;
        }
        if ("datepicker".equalsIgnoreCase(type)) {
            DatePickerConfig datepicker = DatePickerConfig.getInstance();
            datepicker.setId(IDGenerator.getInstance().generate());
            return datepicker;
        }
        if ("numberfield".equalsIgnoreCase(type)) {
            NumberFieldConfig numberfield = NumberFieldConfig.getInstance();
            numberfield.setId(IDGenerator.getInstance().generate());
            return numberfield;
        }
        if ("lov".equalsIgnoreCase(type)) {
            LovConfig lov = LovConfig.getInstance();
            lov.setId(IDGenerator.getInstance().generate());
            return lov;
        }
        if ("combobox".equalsIgnoreCase(type)) {
            ComboBoxConfig combo = ComboBoxConfig.getInstance();
            combo.setId(IDGenerator.getInstance().generate());
            return combo;
        }
        return null;
    }

    private CompositeMap processColumns(CompositeMap model) throws IOException {
        CompositeMap columns;
        GridConfig grid = GridConfig.getInstance(this.view);
        ArrayList<GridColumnConfig> bmColumns = new ArrayList<GridColumnConfig>();
        String href = this.view.getString(PROPERTITY_MODEL, "");
        if (!"".equals(href)) {
            href = TextParser.parse(href, model);
            BusinessModelService modelService = this.mFactory.getModelService(href);
            BusinessModel bm = modelService.getBusinessModel();
            for (Field field : bm.getFields()) {
                if (!field.isForDisplay()) continue;
                GridColumnConfig column = GridColumnConfig.getInstance(field.getObjectContext());
                column.setWidth(field.getDisplayWidth());
                column.setAlign(field.getDisplayAlign());
                if (field.isDateType() && "".equals(column.getRenderer())) {
                    column.setRenderer("Aurora.formatDate");
                }
                bmColumns.add(column);
            }
        }
        if ((columns = this.view.getChild("columns")) != null) {
            List cls = columns.getChilds();
            for (CompositeMap column : cls) {
                boolean defined = false;
                for (GridColumnConfig bmColumn : bmColumns) {
                    String griddataIndex;
                    String bmDataIndex = bmColumn.getName();
                    if (!bmDataIndex.equals(griddataIndex = column.getString("name"))) continue;
                    defined = true;
                    bmColumn.getObjectContext().copy(column);
                    break;
                }
                if (defined) continue;
                GridColumnConfig gc = GridColumnConfig.getInstance(column);
                bmColumns.add(gc);
            }
        }
        CompositeMap viewColumns = new CompositeMap("columns");
        for (GridColumnConfig gc : bmColumns) {
            String dataType = gc.getString("datatype");
            CompositeMap column = gc.getObjectContext();
            if (dataType != null) {
                if ("java.lang.Double".equalsIgnoreCase(dataType)) {
                    column.putString("align", "right");
                    column.putString("renderer", "Aurora.formatMoney");
                } else if ("java.lang.Long".equalsIgnoreCase(dataType)) {
                    column.putString("align", "right");
                    column.putString("renderer", "Aurora.formatNumber");
                }
            }
            viewColumns.addChild(column);
        }
        grid.getObjectContext().replaceChild(grid.getColumns(), viewColumns);
        CompositeMap gridView = grid.getObjectContext();
        return gridView;
    }

    @Override
    public int attachTo(CompositeMap v, Configuration procConfig) {
        this.view = v;
        return 0;
    }
}

