/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap;

import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class InstanceConfig {
    public static final String LOGGING_TOPIC = "aurora.plugin.sap";
    public String sid;
    public String userid;
    public String password;
    public String server_ip;
    public String default_lang;
    public int max_conn;
    public String sap_client;
    public String system_number;
    ILogger logger;
    IRepository repository;
    private boolean inited = false;
    IObjectRegistry mObjectRegistry;

    public InstanceConfig(IObjectRegistry registry) {
        this.mObjectRegistry = registry;
        this.logger = LoggingContext.getLogger((String)LOGGING_TOPIC, (IObjectRegistry)this.mObjectRegistry);
    }

    public void prepare() {
        if (!this.inited) {
            JCO.addClientPool((String)this.sid, (int)this.max_conn, (String)this.sap_client, (String)this.userid, (String)this.password, (String)this.default_lang, (String)this.server_ip, (String)this.system_number);
            this.repository = JCO.createRepository((String)"MYRepository", (String)this.sid);
            if (this.logger != null) {
                this.logger.info("SAP connection pool " + this.sid + " created");
            }
            this.inited = true;
        }
    }

    public IRepository getRepository() {
        if (!this.inited) {
            this.prepare();
        }
        if (this.repository == null) {
            throw new RuntimeException("SAP connection pool can't be created");
        }
        return this.repository;
    }

    public void release() {
        JCO.removeClientPool((String)this.sid);
        if (this.logger != null) {
            this.logger.info("SAP connection pool " + this.sid + " released");
        }
        this.inited = false;
    }

    public JCO.Client getClient() {
        if (!this.inited) {
            this.prepare();
        }
        JCO.Client client = JCO.getClientPoolManager().getClient(this.sid);
        return client;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServer_ip() {
        return this.server_ip;
    }

    public void setServer_ip(String server_ip) {
        this.server_ip = server_ip;
    }

    public String getDefault_lang() {
        return this.default_lang;
    }

    public void setDefault_lang(String default_lang) {
        this.default_lang = default_lang;
    }

    public int getMax_conn() {
        return this.max_conn;
    }

    public void setMax_conn(int max_conn) {
        this.max_conn = max_conn;
    }

    public String getSap_client() {
        return this.sap_client;
    }

    public void setSap_client(String sap_client) {
        this.sap_client = sap_client;
    }

    public String getSystem_number() {
        return this.system_number;
    }

    public void setSystem_number(String system_number) {
        this.system_number = system_number;
    }
}

