/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.mail;

import aurora.database.service.SqlServiceContext;
import aurora.plugin.mail.Attachment;
import aurora.plugin.mail.IMailServerConfig;
import aurora.plugin.mail.SendMail;
import java.util.logging.Level;
import javax.mail.MessagingException;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class AutoSendMail
extends AbstractEntry
implements IConfigurable {
    private IObjectRegistry registry;
    private String title;
    private String content;
    private String smtpServer;
    private String password;
    private String userName;
    private String tto;
    private String cto;
    private String from;
    private String port;
    private Boolean auth = null;
    private Attachment[] attachments;

    public AutoSendMail(IObjectRegistry registry) {
        this.registry = registry;
    }

    public void run(ProcedureRunner runner) throws Exception {
        IMailServerConfig mailConfig = (IMailServerConfig)this.registry.getInstanceOfType(IMailServerConfig.class);
        if (mailConfig != null) {
            this.smtpServer = this.smtpServer != null ? this.smtpServer : mailConfig.getSmtpServer();
            this.userName = this.userName != null ? this.userName : mailConfig.getUserName();
            this.password = this.password != null ? this.password : mailConfig.getPassword();
            this.from = this.from != null ? this.from : mailConfig.getFrom();
            this.port = this.port != null ? this.port : mailConfig.getPort();
            this.auth = this.auth != null ? this.auth.booleanValue() : mailConfig.getAuth();
        }
        if (this.port == null) {
            this.port = "25";
        }
        if (this.auth == null) {
            this.auth = false;
        }
        ILogger logger = LoggingContext.getLogger((String)"aurora.plugin.mail", (IObjectRegistry)this.registry);
        logger.log(Level.CONFIG, "Accept to E-mail message, began sendind mail operation");
        CompositeMap map = runner.getContext();
        SqlServiceContext svcContext = SqlServiceContext.createSqlServiceContext((CompositeMap)map);
        CompositeMap current_param = svcContext.getCurrentParameter();
        SendMail sendMail = new SendMail();
        sendMail.setCto(TextParser.parse((String)this.cto, (CompositeMap)current_param));
        sendMail.setPassword(TextParser.parse((String)this.password, (CompositeMap)current_param));
        sendMail.setSmtpServer(TextParser.parse((String)this.smtpServer, (CompositeMap)current_param));
        sendMail.setTcontent(TextParser.parse((String)this.content, (CompositeMap)current_param));
        sendMail.setTfrom(TextParser.parse((String)this.from, (CompositeMap)current_param));
        sendMail.setTtitle(TextParser.parse((String)this.title, (CompositeMap)current_param));
        sendMail.setTto(TextParser.parse((String)this.tto, (CompositeMap)current_param));
        sendMail.setPort(this.port);
        sendMail.setUserName(TextParser.parse((String)this.userName, (CompositeMap)current_param));
        sendMail.setAuth(this.auth);
        this.convertAttach(runner.getContext());
        sendMail.setAttachments(this.getAttachments());
        try {
            sendMail.check();
            sendMail.sendMail();
            current_param.put((Object)"status", (Object)"SUCCESS");
            logger.log(Level.INFO, "Mail send successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
            current_param.put((Object)"status", (Object)"FAILED");
            current_param.put((Object)"message", (Object)e.getMessage());
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    protected void convertAttach(CompositeMap context) throws MessagingException {
        if (this.attachments != null) {
            for (int i = 0; i < this.attachments.length; ++i) {
                this.attachments[i].setPath(TextParser.parse((String)this.attachments[i].getPath(), (CompositeMap)context));
                this.attachments[i].setName(TextParser.parse((String)this.attachments[i].getName(), (CompositeMap)context));
            }
        }
    }

    public IObjectRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(IObjectRegistry registry) {
        this.registry = registry;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTto() {
        return this.tto;
    }

    public void setTto(String tto) {
        this.tto = tto;
    }

    public String getCto() {
        return this.cto;
    }

    public void setCto(String cto) {
        this.cto = cto;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Attachment[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Attachment[] attaches) {
        this.attachments = attaches;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }
}

