/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bill99.pos;

import aurora.plugin.bill99.Configuration;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import sun.misc.BASE64Encoder;

public class CertificateCoderUtil {
    public static final String KEY_STORE = "PKCS12";
    public static final String X509 = "X.509";

    private static PrivateKey getPrivateKey(String keyStorePath, String alias, String password) throws Exception {
        KeyStore ks = CertificateCoderUtil.getKeyStore(keyStorePath, password);
        PrivateKey key = (PrivateKey)ks.getKey(alias, password.toCharArray());
        return key;
    }

    private static PublicKey getPublicKey(String certificatePath) throws Exception {
        Certificate certificate = CertificateCoderUtil.getCertificate(certificatePath);
        PublicKey key = certificate.getPublicKey();
        return key;
    }

    private static Certificate getCertificate(String certificatePath) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509);
        FileInputStream in = new FileInputStream(certificatePath);
        Certificate certificate = certificateFactory.generateCertificate(in);
        in.close();
        return certificate;
    }

    private static Certificate getCertificate(String keyStorePath, String alias, String password) throws Exception {
        KeyStore ks = CertificateCoderUtil.getKeyStore(keyStorePath, password);
        Certificate certificate = ks.getCertificate(alias);
        return certificate;
    }

    private static KeyStore getKeyStore(String keyStorePath, String password) throws Exception {
        FileInputStream is = new FileInputStream(keyStorePath);
        KeyStore ks = KeyStore.getInstance(KEY_STORE);
        ks.load(is, password.toCharArray());
        is.close();
        return ks;
    }

    public static byte[] encryptByPrivateKey(byte[] data, String keyStorePath, String alias, String password) throws Exception {
        PrivateKey privateKey = CertificateCoderUtil.getPrivateKey(keyStorePath, alias, password);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(1, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPrivateKey(byte[] data, String keyStorePath, String alias, String password) throws Exception {
        PrivateKey privateKey = CertificateCoderUtil.getPrivateKey(keyStorePath, alias, password);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPublicKey(byte[] data, String certificatePath) throws Exception {
        PublicKey publicKey = CertificateCoderUtil.getPublicKey(certificatePath);
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPublicKey(byte[] data, String certificatePath) throws Exception {
        PublicKey publicKey = CertificateCoderUtil.getPublicKey(certificatePath);
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static boolean verifyCertificate(String certificatePath) {
        return CertificateCoderUtil.verifyCertificate(new Date(), certificatePath);
    }

    public static boolean verifyCertificate(Date date, String certificatePath) {
        boolean status = true;
        try {
            Certificate certificate = CertificateCoderUtil.getCertificate(certificatePath);
            status = CertificateCoderUtil.verifyCertificate(date, certificate);
        }
        catch (Exception e) {
            status = false;
        }
        return status;
    }

    private static boolean verifyCertificate(Date date, Certificate certificate) {
        boolean status = true;
        try {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            x509Certificate.checkValidity(date);
        }
        catch (Exception e) {
            status = false;
        }
        return status;
    }

    public static String sign(byte[] sign, String keyStorePath, String alias, String password) throws Exception {
        KeyStore ks = CertificateCoderUtil.getKeyStore(keyStorePath, password);
        PrivateKey privateKey = (PrivateKey)ks.getKey(alias, password.toCharArray());
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initSign(privateKey);
        signature.update(sign);
        return CertificateCoderUtil.encryptBASE64(signature.sign()).replaceAll("\r\n", "");
    }

    public static String sign(byte[] sign) throws Exception {
        String signFile = CertificateCoderUtil.getValue("pos_cp_sign_pfx_file");
        String key = CertificateCoderUtil.getValue("pos_cp_sign_pfx_file_key");
        String psd = CertificateCoderUtil.getValue("pos_cp_sign_pfx_file_password");
        return CertificateCoderUtil.sign(sign, CertificateCoderUtil.class.getClassLoader().getResource(signFile).getPath(), key, psd);
    }

    private static String getValue(String key) {
        String value = Configuration.getValue("bill99", key);
        return value == null ? "" : value;
    }

    public static boolean verify(byte[] data, String sign, String certificatePath) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)CertificateCoderUtil.getCertificate(certificatePath);
        PublicKey publicKey = x509Certificate.getPublicKey();
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initVerify(publicKey);
        signature.update(data);
        return signature.verify(CertificateCoderUtil.decryptBASE64(sign));
    }

    public static boolean verify(byte[] data, String sign) throws Exception {
        String verifyFile = CertificateCoderUtil.getValue("pos_cp_verify_cer_file");
        return CertificateCoderUtil.verify(data, sign, CertificateCoderUtil.class.getClassLoader().getResource(verifyFile).getPath());
    }

    public static boolean verifyCertificate(Date date, String keyStorePath, String alias, String password) {
        boolean status = true;
        try {
            Certificate certificate = CertificateCoderUtil.getCertificate(keyStorePath, alias, password);
            status = CertificateCoderUtil.verifyCertificate(date, certificate);
        }
        catch (Exception e) {
            status = false;
        }
        return status;
    }

    public static boolean verifyCertificate(String keyStorePath, String alias, String password) {
        return CertificateCoderUtil.verifyCertificate(new Date(), keyStorePath, alias, password);
    }

    public static byte[] decryptBASE64(String key) throws Exception {
        return Base64.decodeBase64((byte[])key.getBytes("gb2312"));
    }

    public static String encryptBASE64(byte[] key) throws Exception {
        return new BASE64Encoder().encodeBuffer(key);
    }
}

