/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema;

import uncertain.composite.QualifiedName;
import uncertain.schema.AbstractSchemaObject;
import uncertain.schema.IQualifiedNameAware;
import uncertain.schema.IQualifiedNameResolver;
import uncertain.schema.IQualifiedNamed;
import uncertain.schema.ISchemaObject;
import uncertain.schema.InvalidQNameError;

public abstract class AbstractQualifiedNamed
extends AbstractSchemaObject
implements IQualifiedNamed,
Comparable {
    QualifiedName mQname;
    String mName;

    @Override
    public QualifiedName getQName() {
        return this.mQname;
    }

    @Override
    public void setQName(QualifiedName qname) {
        this.mQname = qname;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getLocalName() {
        return this.mQname == null ? null : this.mQname.getLocalName();
    }

    @Override
    public void resolveQName(IQualifiedNameResolver resolver) {
        if (this.mName != null) {
            this.mQname = resolver.getQualifiedName(this.mName);
            if (this.mQname == null) {
                throw new InvalidQNameError(this.mName);
            }
        }
        if (this.mChilds != null) {
            for (ISchemaObject obj : this.mChilds) {
                if (!(obj instanceof IQualifiedNameAware)) continue;
                ((IQualifiedNameAware)((Object)obj)).resolveQName(resolver);
            }
        }
    }

    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        if (another.getClass().equals(this.getClass()) && this.mQname != null) {
            AbstractQualifiedNamed named = (AbstractQualifiedNamed)another;
            return this.mQname.equals(named.mQname);
        }
        return super.equals(another);
    }

    public int hashCode() {
        if (this.mQname != null) {
            return this.mQname.hashCode();
        }
        return super.hashCode();
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof IQualifiedNamed) {
            IQualifiedNamed qn = (IQualifiedNamed)o;
            if (this.getQName() == null) {
                return -1;
            }
            if (qn.getQName() == null) {
                return 1;
            }
            int result = this.getQName().getLocalName().compareToIgnoreCase(qn.getQName().getLocalName());
            return result;
        }
        return this.hashCode() - o.hashCode();
    }
}

