/*
 * Decompiled with CFR 0.152.
 */
package uncertain.datatype;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import uncertain.datatype.AbstractDataType;
import uncertain.datatype.DataType;

public class BooleanType
extends AbstractDataType
implements DataType {
    @Override
    public Class getJavaType() {
        return Boolean.class;
    }

    @Override
    public int getSqlType() {
        return 16;
    }

    @Override
    public Object getObject(CallableStatement stmt, int id) throws SQLException {
        return stmt.getBoolean(id);
    }

    @Override
    public Object getObject(ResultSet rs, int id) throws SQLException {
        return rs.getBoolean(id);
    }

    @Override
    public void registerParameter(CallableStatement stmt, int id) throws SQLException {
        stmt.registerOutParameter(id, 16);
    }

    @Override
    public void setParameter(PreparedStatement stmt, int id, Object value) throws SQLException {
        Boolean b = (Boolean)value;
        if (b != null) {
            stmt.setBoolean(id, b);
        } else {
            stmt.setNull(id, 16);
        }
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }
}

