/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.exception;

import aurora.application.util.LanguageUtil;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.service.ServiceContext;
import aurora.service.exception.IExceptionDescriptor;
import aurora.service.validation.ErrorMessage;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IConfigurable;

public class BaseExceptionDescriptor
implements IExceptionDescriptor,
IConfigurable {
    public String mMessage;
    public String mCode;
    CompositeMap mConfig;

    public static String getTranslatedMessage(String msg_text, ServiceContext context) {
        ILocalizedMessageProvider lp = (ILocalizedMessageProvider)context.getInstanceOfType(ILocalizedMessageProvider.class);
        return LanguageUtil.getTranslatedMessage(lp, msg_text, context.getCurrentParameter());
    }

    protected ErrorMessage getErrorMessage(ServiceContext context, Throwable exception) {
        String c = this.mCode == null ? exception.getClass().getName() : this.mCode;
        String msg_text = this.mMessage;
        if (msg_text == null) {
            msg_text = exception.getMessage();
        }
        if (msg_text != null) {
            msg_text = BaseExceptionDescriptor.getTranslatedMessage(msg_text, context);
        }
        ErrorMessage msg = new ErrorMessage(c, msg_text, null);
        msg.getObjectContext().putAll(this.mConfig);
        return msg;
    }

    @Override
    public CompositeMap process(ServiceContext context, Throwable exception) {
        ErrorMessage msg = this.getErrorMessage(context, exception);
        return msg.getObjectContext();
    }

    @Override
    public void beginConfigure(CompositeMap config) {
        this.mConfig = config;
    }

    @Override
    public void endConfigure() {
        this.mConfig.remove("code");
        this.mConfig.remove("message");
        this.mConfig.remove("exception");
        this.mConfig.remove("exceptionpattern");
        this.mConfig.remove("handleclass");
    }

    public String getCode() {
        return this.mCode;
    }

    public void setCode(String code) {
        this.mCode = code;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }
}

