/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class TextArea
extends Component {
    public static final String VERSION = "$Revision: 6975 $";
    private static final String DEFAULT_CLASS = "item-textarea";
    protected static final String PROPERTITY_READONLY = "readonly";
    protected static final String CLASSNAME_READONLY = "item-readOnly";

    @Override
    protected int getDefaultWidth() {
        return 150;
    }

    @Override
    protected int getDefaultHeight() {
        return 50;
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        CompositeMap view = context.getView();
        String wrapClass = DEFAULT_CLASS;
        boolean readOnly = view.getBoolean(PROPERTITY_READONLY, false);
        if (readOnly) {
            wrapClass = wrapClass + " item-readOnly";
        }
        return wrapClass;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        Map map = context.getMap();
        boolean readOnly = view.getBoolean(PROPERTITY_READONLY, false);
        if (readOnly) {
            map.put(PROPERTITY_READONLY, PROPERTITY_READONLY);
        }
        this.addConfig(PROPERTITY_READONLY, readOnly);
        map.put("tabindex", new Integer(view.getInt("tabindex", 0)));
        map.put("config", this.getConfigString());
    }
}

