/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.service.ServiceThreadLocal;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class HTMLInclude
implements IViewBuilder {
    public static final String VERSION = "$Revision: 6975 $";
    private IDatabaseServiceFactory factory;
    private static final String PROPERTITY_PATH_FIELD = "pathfield";
    private static final String PROPERTITY_MODEL = "model";
    private static final String PROPERTITY_PARAMS = "params";
    private static final String PROPERTITY_PATH = "path";
    private static final String PROPERTITY_VERSION = "version";
    private String articlePath;
    private String sourcePath;
    private String version;
    private String titlePattern = "<title>.*</title>";
    private String metaPattern = "<meta[^>]*>";
    private String headPattern = "<head>(.*)</head>";
    private String htmlPattern = ".*<html[^>]*>(.*)</html>.*";
    private String bodyPattern = "(.*)<body[^>]*>(.*)</body>(.*)";
    private String scriptPattern = "<script[^>]*src=([\"'])([^'\"]*)\\1[^>]*(/|.*/script)>";
    private String linkPattern = "<link[^>]*href=([\"'])([^'\"]*)\\1[^>]*/?>";
    private String imgPattern = "<img[^>]*src=([\"'])([^'\"]*)\\1[^>]*(/*)>";
    private ClassLoader mClassLoader = Thread.currentThread().getContextClassLoader();

    public HTMLInclude(IDatabaseServiceFactory factory) {
        this.factory = factory;
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        Writer out = session.getWriter();
        try {
            this.init(session, view_context);
            if (null == this.articlePath) {
                return;
            }
            String source = this.getArticalSource(this.articlePath);
            if (null != source && !"".equals(source)) {
                out.write(source);
            }
        }
        catch (ClassNotFoundException e) {
            out.write(e.getMessage());
        }
        catch (Exception e) {
            throw new ViewCreationException(e);
        }
    }

    private void init(BuildSession session, ViewContext view_context) throws Exception {
        BusinessModelService service;
        CompositeMap resultMap;
        CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
        if (context == null) {
            throw new IllegalStateException("No service context set in ThreadLocal yet");
        }
        CompositeMap view = view_context.getView();
        CompositeMap base_model = view_context.getModel();
        String path = TextParser.parse(view.getString(PROPERTITY_PATH), base_model);
        this.version = TextParser.parse(view.getString(PROPERTITY_VERSION), base_model);
        if (null != path && !path.isEmpty()) {
            int begin = path.indexOf("/release");
            if (begin < 0) {
                return;
            }
            path = path.substring(begin, path.length());
            this.articlePath = "../.." + path;
            this.sourcePath = session.getContextPath() + path.replaceAll("\\\\", "/").replaceAll("(.*/)[^/]*$", "$1");
            return;
        }
        String pathField = view.getString(PROPERTITY_PATH_FIELD);
        String model = view.getString(PROPERTITY_MODEL);
        CompositeMap params = view.getChild(PROPERTITY_PARAMS);
        HashMap map = new HashMap();
        if (null != params) {
            Iterator pit = params.getChildIterator();
            while (pit.hasNext()) {
                CompositeMap param = (CompositeMap)pit.next();
                map.put(param.get("name"), TextParser.parse((String)param.get("value"), view_context.getModel()));
            }
        }
        if (null == (resultMap = (service = this.factory.getModelService(model, context)).queryAsMap(map)) || null == resultMap.getChilds()) {
            throw new ClassNotFoundException("\u6587\u7ae0\u672a\u627e\u5230\uff0c\u8f93\u5165\u7684\u8def\u5f84\u4e0d\u6b63\u786e\u3002");
        }
        Iterator it = resultMap.getChildIterator();
        while (it.hasNext()) {
            path = ((CompositeMap)it.next()).getString(pathField);
            if (null == path) continue;
            this.articlePath = "../.." + path;
            this.sourcePath = session.getContextPath() + path.replaceAll("\\\\", "/").replaceAll("(.*/)[^/]*$", "$1");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSource(String path) throws IOException {
        InputStream stream = null;
        try {
            int begin;
            Object f;
            URL url = this.mClassLoader.getResource(path);
            String file = url == null ? null : url.getFile();
            boolean need_stream = false;
            if (file == null) {
                need_stream = true;
            } else {
                f = new File(file);
                if (!((File)f).exists()) {
                    need_stream = true;
                }
            }
            stream = need_stream ? this.mClassLoader.getResourceAsStream(path) : new FileInputStream(file);
            if (stream == null) {
                f = "<h3>\u5173\u4e8e\u6b64\u6807\u7b7e\u7684\u6587\u7ae0\u8fd8\u672a\u53d1\u8868</h3>";
                return f;
            }
            StringBuffer sb = new StringBuffer();
            byte[] buffer = new byte[1024];
            while ((begin = stream.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, begin));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private String getArticalSource(String path) throws IOException {
        return this.parseImg(this.getSource(path));
    }

    private String pase(String source) {
        if (null == source || "".equals(source)) {
            return "";
        }
        return this.replaceAll(this.linkPattern, this.replaceAll(this.scriptPattern, this.replaceAll(this.metaPattern, this.replaceAll(this.titlePattern, this.replaceAll(this.bodyPattern, this.replaceAll(this.headPattern, this.replaceAll(this.htmlPattern, this.replaceAll("</link>", source, ""), "$1"), "$1"), "$1$2$3"), ""), ""), "<script src='" + this.sourcePath + "$2'></script>"), "<link rel='stylesheet' type='text/css' href='" + this.sourcePath + "$2'/>");
    }

    private String parseImg(String source) {
        if (null == this.version || this.version.isEmpty()) {
            return this.pase(source);
        }
        return this.replaceAll(this.imgPattern, this.pase(source), "<img src='release/" + this.version + "/$2'/>");
    }

    private String replaceAll(String regex, CharSequence input, String replacement) {
        return Pattern.compile(regex, 32).matcher(input).replaceAll(replacement);
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

