/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Field;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Button
extends Field {
    public static final String VERSION = "$Revision: 6975 $";
    public static final String TAG_NAME = "button";
    public static final String CLASSNAME_WRAP = "item-btn";
    public static final String PROPERTITY_TEXT = "text";
    public static final String PROPERTITY_TEXT_HEIGHT = "text_height";
    public static final String PROPERTITY_ICON = "icon";
    public static final String BUTTON_STYLE = "btnstyle";
    public static final String BUTTON_CLASS = "btnclass";
    public static final String PROPERTITY_CLICK = "click";
    public static final String PROPERTITY_TITLE = "title";
    public static final String PROPERTITY_DISABLED = "disabled";
    private static final String PROPERTITY_ICON_ALIGN = "iconalign";
    private static final int DEFAULT_HEIGHT = 16;
    private static final int DEFAULT_WIDTH = 60;
    private static final int DEFAULT_ALIGN_TOP_HEIGHT = 36;
    private static final int DEFAULT_ALIGN_TOP_WIDTH = 50;
    private boolean isAlignTop = false;

    @Override
    protected int getDefaultWidth() {
        return this.isAlignTop ? 50 : 60;
    }

    @Override
    protected int getDefaultHeight() {
        return this.isAlignTop ? 36 : 16;
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        CompositeMap view = context.getView();
        String text = view.getString(PROPERTITY_TEXT, "");
        String icon = view.getString(PROPERTITY_ICON, "");
        String align = view.getString(PROPERTITY_ICON_ALIGN, "left");
        String wrapClass = CLASSNAME_WRAP;
        if (!"".equals(icon)) {
            if (!"".equals(text)) {
                if ("top".equals(align)) {
                    this.isAlignTop = true;
                    wrapClass = wrapClass + " item-btn-icon-text-top";
                } else {
                    wrapClass = wrapClass + " item-btn-icon-text";
                }
            } else {
                wrapClass = wrapClass + " item-btn-icon";
            }
        }
        return wrapClass;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        CompositeMap model = context.getModel();
        CompositeMap view = context.getView();
        Map map = context.getMap();
        String clickEvent = view.getString(PROPERTITY_CLICK, "");
        if (!"".equals(clickEvent)) {
            if (clickEvent.indexOf("${") != -1) {
                clickEvent = TextParser.parse(clickEvent, model);
            }
            this.addEvent(this.id, PROPERTITY_CLICK, clickEvent);
        }
        String text = view.getString(PROPERTITY_TEXT, "&#160;");
        text = session.getLocalizedPrompt(text);
        boolean disabled = view.getBoolean(PROPERTITY_DISABLED, false);
        if (disabled) {
            this.addConfig(PROPERTITY_DISABLED, disabled);
        }
        String icon = view.getString(PROPERTITY_ICON, "");
        String btnstyle = view.getString(BUTTON_STYLE, "");
        if (!"".equals(icon) && !"null".equalsIgnoreCase(icon)) {
            btnstyle = btnstyle + "background-image:url(" + TextParser.parse(icon, model) + ");";
        }
        Integer text_height = (Integer)map.get("height");
        if (this.isAlignTop) {
            text_height = null;
        }
        map.put(PROPERTITY_TEXT_HEIGHT, text_height);
        map.put(PROPERTITY_TEXT, text);
        map.put(BUTTON_CLASS, view.getString(BUTTON_CLASS, ""));
        map.put(PROPERTITY_TITLE, view.getString(PROPERTITY_TITLE, ""));
        map.put("tabindex", new Integer(view.getInt("tabindex", 0)));
        map.put(BUTTON_STYLE, btnstyle);
        map.put("config", this.getConfigString());
    }
}

