/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.service;

import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;

public class ServiceOption
extends DynamicObject {
    public static final String KEY_AUTO_COUNT = "autocount";
    public static final String MODE_FREE_QUERY = "freequery";
    public static final String MODE_BY_PK = "pkquery";
    public static final String KEY_DEFAULT_WHERE_CLAUSE = "defaultwhereclause";
    public static final String KEY_QUERY_ORDER_BY = "queryorderby";
    public static final String KEY_CONNECTION_NAME = "connectionname";
    public static final String KEY_FIELD_CASE = "fieldcase";
    public static final String KEY_RECORD_NAME = "recordname";
    public static final String KEY_UPDATE_PASSED_FIELD_ONLY = "updatepassedfieldonly";

    public String getConnectionName() {
        return this.getString(KEY_CONNECTION_NAME);
    }

    public void setConnectionName(String connectionName) {
        this.putString(KEY_CONNECTION_NAME, connectionName);
    }

    public static ServiceOption createInstance() {
        CompositeMap map = new CompositeMap(20);
        map.setName("service-option");
        ServiceOption option = new ServiceOption();
        option.initialize(map);
        return option;
    }

    public String getQueryMode() {
        return this.getString("querymode");
    }

    public void setQueryMode(String mode) {
        this.putString("querymode", mode);
    }

    public boolean isFreeQuery() {
        return MODE_FREE_QUERY.equalsIgnoreCase(this.getQueryMode());
    }

    public boolean isPkQuery() {
        return MODE_BY_PK.equalsIgnoreCase(this.getQueryMode());
    }

    public boolean isUpdatePassedFieldOnly() {
        return "true".equalsIgnoreCase(this.getString(KEY_UPDATE_PASSED_FIELD_ONLY));
    }

    public boolean isAutoCount() {
        return this.getBoolean(KEY_AUTO_COUNT, false);
    }

    public void setAutoCount(boolean b) {
        this.putBoolean(KEY_AUTO_COUNT, b);
    }

    public String getQueryOrderBy() {
        return this.getString(KEY_QUERY_ORDER_BY);
    }

    public void setQueryOrderBy(String order_by) {
        this.putString(KEY_QUERY_ORDER_BY, order_by);
    }

    public String getDefaultWhereClause() {
        return this.getString(KEY_DEFAULT_WHERE_CLAUSE);
    }

    public void setDefaultWhereClause(String where) {
        this.putString(KEY_DEFAULT_WHERE_CLAUSE, where);
    }

    public byte getFieldCase() {
        return (byte)this.getInt(KEY_FIELD_CASE, 0);
    }

    public void setFieldCase(byte field_case) {
        this.putInt(KEY_FIELD_CASE, field_case);
    }

    public void setUpdatePassedFieldOnly(boolean b) {
        this.putBoolean(KEY_UPDATE_PASSED_FIELD_ONLY, b);
    }

    public void setRecordName(String record_name) {
        this.putString(KEY_RECORD_NAME, record_name);
    }

    public String getRecordName() {
        return this.getString(KEY_RECORD_NAME);
    }
}

