/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.service;

import aurora.bm.BusinessModel;
import aurora.database.SqlRunner;
import aurora.database.service.SqlServiceContext;
import aurora.database.sql.ISqlStatement;
import uncertain.composite.CompositeMap;

public class BusinessModelServiceContext
extends SqlServiceContext {
    public static final String KEY_BUSINESS_MODEL = "BusinessModel";
    public static final String KEY_STATEMENT = "SqlStatement";
    public static final String KEY_OPERATION = "BusinessModelOperation";
    public static final String KEY_SQL_RUNNER = "SqlRunner";
    public static final String KEY_STATEMENT_TYPE = "SqlStatementType";
    public static final String KEY_SQL_GENERATION_MODE = "SqlGenerationMode";

    public static BusinessModelServiceContext getContextInstance(CompositeMap map) {
        BusinessModelServiceContext context = new BusinessModelServiceContext();
        context.initialize(map);
        return context;
    }

    public BusinessModel getBusinessModel() {
        return (BusinessModel)this.get(KEY_BUSINESS_MODEL);
    }

    public void setBusinessModel(BusinessModel model) {
        this.put(KEY_BUSINESS_MODEL, model);
    }

    public ISqlStatement getStatement() {
        return (ISqlStatement)this.get(KEY_STATEMENT);
    }

    public void setStatement(ISqlStatement statement) {
        this.put(KEY_STATEMENT, statement);
    }

    public SqlRunner getSqlRunner() {
        return (SqlRunner)this.get(KEY_SQL_RUNNER);
    }

    public void setSqlRunner(SqlRunner runner) {
        this.put(KEY_SQL_RUNNER, runner);
    }

    public String getOperation() {
        return this.getString(KEY_OPERATION);
    }

    public void setOperation(String action) {
        this.putString(KEY_OPERATION, action);
    }

    public String getStatementType() {
        return this.getString(KEY_STATEMENT_TYPE);
    }

    public void setStatementType(String type) {
        this.putString(KEY_STATEMENT_TYPE, type);
    }

    public void setSqlGenerationMode(String mode) {
        this.putString(KEY_SQL_GENERATION_MODE, mode);
    }

    public String getSqlGenerationMode() {
        return this.getString(KEY_SQL_GENERATION_MODE);
    }

    public void prepareForRun() {
        this.setSqlRunner(null);
        this.setSqlString(null);
        this.setBusinessModel(null);
        this.setSqlGenerationMode(null);
        this.setStatementType(null);
        this.setStatement(null);
    }
}

