/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.rsconsumer;

import aurora.database.IResultSetConsumer;
import aurora.database.service.SqlServiceContext;
import aurora.service.ServiceThreadLocal;
import java.util.List;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureConfigManager;
import uncertain.proc.ProcedureRunner;

public class ModelActionConsumerWrapper
extends AbstractLocatableObject
implements IResultSetConsumer {
    protected CompositeMap currentRecord;
    private CompositeMap proc_config;
    private ProcedureRunner runner;
    private ILogger logger;
    private SqlServiceContext svcContext;
    private CompositeMap old_current_param;
    CompositeMap context;
    private boolean useTransactionManager;
    private IProcedureManager procedureManager;
    private long rownum;

    public ModelActionConsumerWrapper(IProcedureManager procedureManager, IObjectRegistry registry) {
        this.procedureManager = procedureManager;
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), registry);
    }

    @Override
    public void begin(String root_name) {
        this.rownum = 0L;
        this.logger.info("begin execute");
        try {
            this.context = ServiceThreadLocal.getCurrentThreadContext();
            if (this.context == null) {
                this.context = new CompositeMap();
            }
            this.runner = this.createProcedureRunner(this.context, this.proc_config);
            this.runner.setSaveStackTrace(true);
            this.svcContext = SqlServiceContext.createSqlServiceContext(this.context);
            this.old_current_param = this.svcContext.getCurrentParameter();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public void newRow(String row_name) {
        ++this.rownum;
        this.currentRecord = new CompositeMap(row_name);
    }

    @Override
    public void loadField(String name, Object value) {
        this.currentRecord.put(name, value);
    }

    @Override
    public void endRow() {
        try {
            this.logger.config("rownum :" + this.rownum + " currentRecord:" + this.currentRecord.toXML());
            this.runModelAction(this.currentRecord);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end() {
        this.svcContext.setCurrentParameter(this.old_current_param);
        this.logger.info("finished execute,count :" + this.rownum);
    }

    @Override
    public void setRecordCount(long count) {
        this.logger.config("count :" + count);
    }

    @Override
    public Object getResult() {
        return null;
    }

    public void runModelAction(CompositeMap record) throws Exception {
        this.svcContext.setCurrentParameter(record);
        this.runner.setSaveStackTrace(true);
        this.runner.run();
        this.runner.checkAndThrow();
    }

    public ProcedureRunner createProcedureRunner(CompositeMap context, CompositeMap proc_config) {
        ProcedureRunner runner = new ProcedureRunner();
        runner.setContext(context);
        Procedure proc = null;
        proc = this.procedureManager.createProcedure(proc_config);
        runner.setProcedure(proc);
        return runner;
    }

    @Override
    public void beginConfigure(CompositeMap config) {
        List childs = config.getChilds();
        if (childs == null || childs.isEmpty()) {
            throw BuiltinExceptionFactory.createNodeMissing(this, "ModelAction");
        }
        this.proc_config = ProcedureConfigManager.createConfigNode("procedure");
        this.proc_config.addChilds(config.getChilds());
        this.logger.config("proc_config:" + this.proc_config.toXML());
    }

    public boolean getUseTransactionManager() {
        return this.useTransactionManager;
    }

    public void setUseTransactionManager(boolean useTransactionManager) {
        this.useTransactionManager = useTransactionManager;
        ServiceThreadLocal.setUseTransactionManager(useTransactionManager);
    }
}

