/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import java.util.Iterator;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.composite.QualifiedName;
import uncertain.core.ConfigurationError;

public class Operation
extends DynamicObject {
    public static final QualifiedName UPDATE_SQL = new QualifiedName("http://www.aurora-framework.org/schema/bm", "update-sql");
    public static final QualifiedName QUERY_SQL = new QualifiedName("http://www.aurora-framework.org/schema/bm", "query-sql");
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_NAME = "name";
    public static final String EXECUTE = "execute";
    public static final String DELETE = "delete";
    public static final String UPDATE = "update";
    public static final String INSERT = "insert";
    public static final String QUERY = "query";
    String name;
    boolean mIsQuery = false;
    String mSql;

    public String getName() {
        return this.getString(KEY_NAME);
    }

    public void setName(String name) {
        this.putString(KEY_NAME, name);
    }

    public List getParameters() {
        CompositeMap params = this.object_context.getChild(KEY_PARAMETERS);
        return params == null ? null : params.getChilds();
    }

    public boolean isQuery() {
        return this.mIsQuery;
    }

    public String getSql() {
        return this.mSql;
    }

    protected void prepare() {
        Iterator it = this.object_context.getChildIterator();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap item = (CompositeMap)it.next();
                QualifiedName qname = item.getQName();
                if (UPDATE_SQL.equals(qname)) {
                    if (this.mSql != null) {
                        throw new ConfigurationError("duplicate sql statement:" + item.toXML());
                    }
                    this.mIsQuery = false;
                    this.mSql = item.getText();
                    continue;
                }
                if (!QUERY_SQL.equals(qname)) continue;
                if (this.mSql != null) {
                    throw new ConfigurationError("duplicate sql statement:" + item.toXML());
                }
                this.mIsQuery = true;
                this.mSql = item.getText();
            }
        }
    }

    @Override
    public DynamicObject initialize(CompositeMap context) {
        super.initialize(context);
        this.prepare();
        return this;
    }

    public static Operation createOperation(CompositeMap config) {
        Operation op = new Operation();
        op.initialize(config);
        return op;
    }
}

