/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.presentation.component.std.config.EventConfig;
import aurora.presentation.component.std.config.FormConfig;
import aurora.presentation.component.std.config.TextFieldConfig;
import aurora.service.ServiceContext;
import java.io.IOException;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.event.Configuration;
import uncertain.proc.IFeature;
import uncertain.proc.ProcedureRunner;

public class AutoForm
implements IFeature {
    private static final String PROPERTITY_MODEL = "model";
    private static final String PROPERTITY_ENTERDOWN_HANDLER = "enterdownhandler";
    IModelFactory mFactory;
    CompositeMap view;

    public AutoForm(IModelFactory factory) {
        this.mFactory = factory;
    }

    public int onCreateView(ProcedureRunner runner) throws IOException {
        ServiceContext sc = ServiceContext.createServiceContext(runner.getContext());
        CompositeMap model = sc.getModel();
        FormConfig formConfig = FormConfig.getInstance(this.view);
        formConfig.setCellspacing(0);
        String target = this.view.getString("bindtarget", "");
        String handler = this.view.getString(PROPERTITY_ENTERDOWN_HANDLER);
        String labelWidth = TextParser.parse(this.view.getString("labelwidth"), model);
        formConfig.put("labelwidth", "".equals(labelWidth) ? null : labelWidth);
        String href = this.view.getString(PROPERTITY_MODEL, "");
        if (!"".equals(href)) {
            href = TextParser.parse(href, model);
            BusinessModel bm = this.mFactory.getModel(href);
            for (Field field : bm.getFields()) {
                if (!field.isForQuery()) continue;
                TextFieldConfig textField = TextFieldConfig.getInstance(field.getObjectContext());
                textField.setWidth(field.getQueryWidth());
                if (!"".equals(target)) {
                    textField.setBindTarget(target);
                }
                if (handler != null) {
                    EventConfig ec = EventConfig.getInstance();
                    ec.setEventName("enterdown");
                    ec.setHandler(handler);
                    textField.addEvent(ec);
                }
                formConfig.addChild(textField.getObjectContext());
            }
        }
        this.view.getParent().replaceChild(this.view, formConfig.getObjectContext());
        return 0;
    }

    @Override
    public int attachTo(CompositeMap v, Configuration procConfig) {
        this.view = v;
        return 0;
    }
}

