/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.poi;

import aurora.i18n.ILocalizedMessageProvider;
import aurora.plugin.export.MergedHeader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import uncertain.composite.CompositeMap;
import uncertain.composite.transform.GroupTransformer;

public class ExcelExportImpl {
    public static final String KEY_DATA_TYPE = "dataType";
    public static final String KEY_DATA_TYPE_NUMBER = "Number";
    public static final String KEY_DATA_TYPE_STRING = "String";
    ILocalizedMessageProvider localMsgProvider;
    Workbook wb;
    CompositeMap dataModel;
    CompositeMap mergeColumn;
    CompositeMap headerConfig;
    List<CompositeMap> headerList;
    final int numberLimit = 65535;
    int headLevel;
    HSSFCellStyle headstyle;
    HSSFCellStyle bodystyle;

    public ExcelExportImpl(ILocalizedMessageProvider localMsgProvider) {
        this.localMsgProvider = localMsgProvider;
    }

    public void createExcel(CompositeMap dataModel, CompositeMap column_config, OutputStream os, CompositeMap merge_column) throws Exception {
        if (merge_column != null) {
            CompositeMap groupConfig = null;
            Iterator it = merge_column.getChildIterator();
            if (it != null) {
                groupConfig = new CompositeMap();
                while (it.hasNext()) {
                    CompositeMap record = (CompositeMap)it.next();
                    CompositeMap configRecord = new CompositeMap();
                    configRecord.put((Object)"group_key_fields", (Object)record.getString((Object)"name"));
                    configRecord.put((Object)"record_name", (Object)record.getString((Object)"name"));
                    groupConfig.addChild(configRecord);
                }
            }
            this.mergeColumn = groupConfig;
            this.dataModel = GroupTransformer.transformByConfig((CompositeMap)dataModel, (CompositeMap)this.mergeColumn);
        } else {
            this.dataModel = dataModel;
        }
        this.headerConfig = new MergedHeader((CompositeMap)column_config).conifg;
        this.wb = new HSSFWorkbook();
        this.setCellStyle(this.wb);
        this.createExcel();
        try {
            this.wb.write(os);
            os.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            os.close();
        }
    }

    void setCellStyle(Workbook wb) {
        this.headstyle = (HSSFCellStyle)wb.createCellStyle();
        HSSFFont headfont = (HSSFFont)wb.createFont();
        headfont.setFontName("\u5b8b\u4f53");
        headfont.setBoldweight((short)700);
        headfont.setFontHeightInPoints((short)12);
        this.headstyle.setFont(headfont);
        this.headstyle.setAlignment((short)2);
        this.headstyle.setVerticalAlignment((short)1);
        this.bodystyle = (HSSFCellStyle)wb.createCellStyle();
        this.bodystyle.setVerticalAlignment((short)1);
        HSSFFont bodyfont = (HSSFFont)wb.createFont();
        bodyfont.setFontName("\u5b8b\u4f53");
        bodyfont.setBoldweight((short)400);
        bodyfont.setFontHeightInPoints((short)12);
        this.bodystyle.setFont(bodyfont);
    }

    short getExcelAlign(String align) {
        int excelAlign = 0;
        if (align == null || "left".equalsIgnoreCase(align)) {
            excelAlign = 1;
        } else if ("right".equalsIgnoreCase(align)) {
            excelAlign = 3;
        } else if ("center".equalsIgnoreCase(align)) {
            excelAlign = 2;
        }
        return (short)excelAlign;
    }

    void createExcel() {
        Sheet sheet = null;
        Iterator iterator = this.dataModel.getChildIterator();
        this.headLevel = 0;
        sheet = this.wb.createSheet();
        this.createExcelHeader(sheet);
        sheet.createFreezePane(0, ++this.headLevel);
        if (iterator != null) {
            if (this.mergeColumn != null) {
                this.createExcelTableMerge(sheet, this.dataModel);
            } else {
                this.createExcelTable(sheet, iterator);
            }
        }
    }

    void createExcelHeader(Sheet sheet) {
        Row header = sheet.createRow(0);
        this.headerList = new LinkedList<CompositeMap>();
        this.generatExcelHead(this.headerConfig, sheet, header, -1);
    }

    void createExcelTableMerge(Sheet sheet, CompositeMap record) {
        int mergeCount = 0;
        int col = 0;
        Iterator iterator = record.getChildIterator();
        while (iterator.hasNext()) {
            CompositeMap childRecord = (CompositeMap)iterator.next();
            Iterator it = childRecord.getChildIterator();
            if (it != null) {
                this.createExcelTableMerge(sheet, childRecord);
                mergeCount = childRecord.getInt((Object)"_count");
                String colName = childRecord.getName();
                int l = this.headerList.size();
                for (int i = 0; i < l; ++i) {
                    CompositeMap head = this.headerList.get(i);
                    if (!colName.equals(head.get((Object)"name"))) continue;
                    col = i;
                    break;
                }
                org.apache.poi.hssf.util.CellRangeAddress range = new org.apache.poi.hssf.util.CellRangeAddress(this.headLevel - mergeCount, this.headLevel - 1, col, col);
                sheet.addMergedRegion((CellRangeAddress)range);
                int count = record.getInt((Object)"_count", 0);
                record.put((Object)"_count", (Object)(count + mergeCount));
                continue;
            }
            this.createExcelTable(sheet, record.getChildIterator());
            record.put((Object)"_count", (Object)record.getChilds().size());
            break;
        }
    }

    void createExcelTable(Sheet sheet, Iterator iterator) {
        boolean is_setwidth = false;
        int col = 0;
        while (iterator.hasNext() && this.headLevel != 65535) {
            CompositeMap object = (CompositeMap)iterator.next();
            if (!"record".equals(object.getName())) continue;
            Row row = sheet.getRow(this.headLevel);
            if (row == null) {
                row = sheet.createRow(this.headLevel);
            }
            Iterator<CompositeMap> it = this.headerList.iterator();
            while (it.hasNext()) {
                Cell cell = row.createCell(col);
                CompositeMap record = it.next();
                String columnName = record.getString((Object)"name");
                Object value = object.get((Object)columnName);
                this.bodystyle.setAlignment(this.getExcelAlign(record.getString((Object)"align")));
                cell.setCellType(1);
                cell.setCellStyle((CellStyle)this.bodystyle);
                if (value != null) {
                    if (record.getString((Object)KEY_DATA_TYPE) != null) {
                        if (KEY_DATA_TYPE_STRING.equalsIgnoreCase(record.getString((Object)KEY_DATA_TYPE))) {
                            cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
                        } else {
                            try {
                                cell.setCellValue(Double.parseDouble(value.toString()));
                            }
                            catch (Exception e) {
                                cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
                            }
                        }
                    } else {
                        if (value instanceof String) {
                            cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
                        }
                        if (value instanceof Number) {
                            cell.setCellValue(Double.parseDouble(value.toString()));
                        }
                    }
                }
                if (!is_setwidth) {
                    int width = record.getInt((Object)"width", 100);
                    sheet.setColumnWidth(col, (int)((short)((double)width * 35.7)));
                }
                ++col;
            }
            is_setwidth = true;
            col = 0;
            ++this.headLevel;
        }
    }

    String getPrompt(String key) {
        String promptString = this.localMsgProvider.getMessage(key);
        promptString = promptString == null ? key : promptString;
        return promptString;
    }

    int generatExcelHead(CompositeMap columnConfigs, Sheet sheet, Row header, int col) {
        int rownum = header.getRowNum();
        Iterator iterator = columnConfigs.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                org.apache.poi.hssf.util.CellRangeAddress range;
                Iterator it;
                CompositeMap record = (CompositeMap)iterator.next();
                String title = this.getPrompt(record.getString((Object)"prompt"));
                Cell cell = header.createCell(++col);
                cell.setCellValue((RichTextString)new HSSFRichTextString(title));
                cell.setCellStyle((CellStyle)this.headstyle);
                int level = record.getInt((Object)"_level", 0);
                if (this.headLevel == 0) {
                    this.headLevel = level;
                }
                if ((it = record.getChildIterator()) != null) {
                    Long span = (Long)record.getObject("column/@_count");
                    range = new org.apache.poi.hssf.util.CellRangeAddress(rownum, rownum, col, col + span.intValue() - 1);
                    sheet.addMergedRegion((CellRangeAddress)range);
                    while (it.hasNext()) {
                        Row nextRow = sheet.getRow(rownum + 1);
                        if (nextRow == null) {
                            nextRow = sheet.createRow(rownum + 1);
                        }
                        CompositeMap object = (CompositeMap)it.next();
                        col = this.generatExcelHead(object, sheet, nextRow, col - 1);
                    }
                    continue;
                }
                this.headerList.add(record);
                if (level == 0) continue;
                range = new org.apache.poi.hssf.util.CellRangeAddress(rownum, rownum + level, col, col);
                sheet.addMergedRegion((CellRangeAddress)range);
            }
        }
        return col;
    }
}

