/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.export;

import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import aurora.plugin.export.task.IReportTask;
import aurora.plugin.poi.ExcelExportImpl;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class ModelOutput {
    public static final String KEY_COLUMN_CONFIG = "_column_config_";
    public static final String KEY_FILE_NAME = "_file_name_";
    public static final String KEY_CHARSET = "GBK";
    public static final String KEY_PROMPT = "prompt";
    public static final String KEY_DATA_INDEX = "name";
    public static final String KEY_MERGE_COLUMN = "_merge_column_";
    public static final String KEY_COLUMN = "column";
    public static final String KEY_WIDTH = "width";
    public static final String KEY_GENERATE_STATE = "_generate_state";
    public static final String KEY_FORMAT = "_format";
    public static final String KEY_SEPARATOR = "separator";
    public static final String KEY_ENABLETASK = "enableTask";
    private File excelDir;
    IObjectRegistry mObjectRegistry;
    int modelQueryTagNum;

    public ModelOutput(IObjectRegistry registry) {
        this.mObjectRegistry = registry;
    }

    public int preInvokeService(ServiceContext context) throws Exception {
        CompositeMap parameters = context.getParameter();
        if (!parameters.getBoolean((Object)KEY_GENERATE_STATE, false)) {
            return 0;
        }
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        CompositeMap config = svc.getServiceConfigData().getChild("init-procedure");
        if (config == null) {
            mLogger.log(Level.SEVERE, "init-procedure tag must be defined");
            throw new ServletException("init-procedure tag must be defined");
        }
        String return_path = (String)svc.getServiceConfigData().getObject("service-output/@output");
        if (return_path == null) {
            mLogger.log(Level.SEVERE, "service-output tag must be defined");
            throw new ServletException("service-output tag must be defined");
        }
        if (!return_path.startsWith("/")) {
            return_path = "/" + return_path;
        }
        this.modelQueryTagNum = 0;
        if (this.createConsumerTag(config, return_path, parameters) && this.modelQueryTagNum == 0) {
            mLogger.log(Level.SEVERE, "The path '" + return_path + "' can't find model-query tag");
            throw new ServletException("The path '" + return_path + "' can't find model-query tag");
        }
        boolean enableTask = this.isEnableTask(parameters);
        if (enableTask && this.excelDir == null) {
            IReportTask excelTask = (IReportTask)this.mObjectRegistry.getInstanceOfType(IReportTask.class);
            if (excelTask == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IReportTask.class, (String)this.getClass().getCanonicalName());
            }
            File excelDirectory = new File(excelTask.getReportDir());
            if (!excelDirectory.exists()) {
                throw new IllegalArgumentException("File " + excelTask.getReportDir() + " is not exits!");
            }
            if (!excelDirectory.isDirectory()) {
                throw new IllegalArgumentException("File " + excelTask.getReportDir() + " is not directory!");
            }
            this.excelDir = excelDirectory;
        }
        return 0;
    }

    boolean createConsumerTag(CompositeMap actionConfig, String return_path, CompositeMap parameters) {
        if (this.modelQueryTagNum != 0) {
            return true;
        }
        Iterator iterator = actionConfig.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext() && !this.createConsumerTag((CompositeMap)iterator.next(), return_path, parameters)) {
            }
        } else {
            String rootpath = actionConfig.getString((Object)"rootpath");
            if (rootpath != null) {
                if (!rootpath.startsWith("/")) {
                    rootpath = "/model/" + rootpath;
                }
                if ("model-query".equals(actionConfig.getName()) && return_path.equalsIgnoreCase(rootpath)) {
                    actionConfig.putBoolean((Object)"fetchall", true);
                    String format = parameters.getString((Object)KEY_FORMAT);
                    if ("xlsx".equals(format)) {
                        actionConfig.createChildByTag("consumer").createChildByTag("output-excel").setNameSpaceURI("http://www.aurora-framework.org/application");
                        ++this.modelQueryTagNum;
                        return true;
                    }
                    if ("txt".equals(format)) {
                        actionConfig.createChildByTag("consumer").createChildByTag("output-txt").setNameSpaceURI("http://www.aurora-framework.org/application");
                        ++this.modelQueryTagNum;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int preCreateSuccessResponse(ServiceContext context) throws Exception {
        CompositeMap parameter = context.getParameter();
        if (!parameter.getBoolean((Object)KEY_GENERATE_STATE, false)) {
            return 0;
        }
        if (!"xls".equals(parameter.getString((Object)KEY_FORMAT))) {
            return 2;
        }
        IMessageProvider msgProvider = (IMessageProvider)this.mObjectRegistry.getInstanceOfType(IMessageProvider.class);
        String langString = context.getSession().getString((Object)"lang", "ZHS");
        ILocalizedMessageProvider localMsgProvider = msgProvider.getLocalizedMessageProvider(langString);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        ExcelExportImpl excelFactory = new ExcelExportImpl(localMsgProvider);
        if (!this.isEnableTask(parameter)) {
            HttpServletResponse response = ((HttpServiceInstance)svc).getResponse();
            String fileName = parameter.getString((Object)KEY_FILE_NAME, "excel");
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding(KEY_CHARSET);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes(), "ISO-8859-1") + ".xls\"");
            excelFactory.createExcel(this.getExportData(context), this.getColumnConfig(context), (OutputStream)response.getOutputStream(), context.getParameter().getChild(KEY_MERGE_COLUMN));
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String date = dateFormat.format(new Date());
            String fileName = parameter.getString((Object)KEY_FILE_NAME, "excel_") + date + "_" + System.currentTimeMillis() + ".xls";
            File excel = new File(this.excelDir, fileName);
            if (excel.createNewFile()) {
                FileOutputStream os = new FileOutputStream(excel);
                try {
                    excelFactory.createExcel(this.getExportData(context), this.getColumnConfig(context), os, context.getParameter().getChild(KEY_MERGE_COLUMN));
                }
                finally {
                    if (os != null) {
                        os.flush();
                        ((OutputStream)os).close();
                    }
                }
            }
            parameter.put((Object)"file_path", (Object)excel.getCanonicalPath());
        }
        return 2;
    }

    CompositeMap getExportData(ServiceContext context) throws ServletException {
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        String return_path = (String)svc.getServiceConfigData().getObject("service-output/@output");
        if (return_path == null) {
            mLogger.log(Level.SEVERE, "service-output must be defined");
            throw new ServletException("service-output must be defined");
        }
        CompositeMap exportData = (CompositeMap)context.getObjectContext().getObject(return_path);
        return exportData;
    }

    CompositeMap getColumnConfig(ServiceContext context) throws ServletException {
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        CompositeMap column_config = (CompositeMap)context.getParameter().getObject("_column_config_/column");
        if (column_config == null) {
            mLogger.log(Level.SEVERE, "_column_config_ tag and column attibute must be defined");
            throw new ServletException("_column_config_ tag and column attibute must be defined");
        }
        return column_config;
    }

    private boolean isEnableTask(CompositeMap parameter) {
        if (parameter == null) {
            return false;
        }
        boolean enableTask = parameter.getBoolean((Object)KEY_ENABLETASK, false);
        return enableTask;
    }
}

