/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.export;

import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import aurora.plugin.export.task.IReportTask;
import aurora.plugin.poi.ExcelExportImpl;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class ModelExport {
    public final String KEY_COLUMN_CONFIG = "_column_config_";
    public final String KEY_FILE_NAME = "_file_name_";
    public final String KEY_MERGE_COLUMN = "_merge_column_";
    public final String KEY_CHARSET = "GBK";
    public final String KEY_PROMPT = "prompt";
    public final String KEY_DATA_INDEX = "name";
    public final String KEY_COLUMN = "column";
    public final String KEY_WIDTH = "width";
    public final String KEY_GENERATE_STATE = "_generate_state";
    public final String KEY_FORMAT = "_format";
    public static final String KEY_ENABLETASK = "enableTask";
    private File excelDir;
    IObjectRegistry mObjectRegistry;

    public ModelExport(IObjectRegistry registry) {
        this.mObjectRegistry = registry;
    }

    public int preInvokeService(ServiceContext context) throws Exception {
        CompositeMap parameters;
        boolean enableTask;
        if (!context.getParameter().getBoolean((Object)"_generate_state", false)) {
            return 0;
        }
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        CompositeMap config = svc.getServiceConfigData().getChild("init-procedure");
        if (config == null) {
            mLogger.log(Level.SEVERE, "init-procedure tag must be defined");
            throw new ServletException("init-procedure tag must be defined");
        }
        Iterator iterator = config.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                CompositeMap modelQueryMap = (CompositeMap)iterator.next();
                if (!"model-query".equals(modelQueryMap.getName())) continue;
                modelQueryMap.putBoolean((Object)"fetchall", true);
            }
        }
        if ((enableTask = this.isEnableTask(parameters = context.getParameter())) && this.excelDir == null) {
            IReportTask excelTask = (IReportTask)this.mObjectRegistry.getInstanceOfType(IReportTask.class);
            if (excelTask == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IReportTask.class, (String)this.getClass().getCanonicalName());
            }
            File excelDirectory = new File(excelTask.getReportDir());
            if (!excelDirectory.exists()) {
                throw new IllegalArgumentException("File " + excelTask.getReportDir() + " is not exits!");
            }
            if (!excelDirectory.isDirectory()) {
                throw new IllegalArgumentException("File " + excelTask.getReportDir() + " is not directory!");
            }
            this.excelDir = excelDirectory;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int preCreateSuccessResponse(ServiceContext context) throws Exception {
        CompositeMap parameter = context.getParameter();
        if (!parameter.getBoolean((Object)"_generate_state", false)) {
            return 0;
        }
        IMessageProvider msgProvider = (IMessageProvider)this.mObjectRegistry.getInstanceOfType(IMessageProvider.class);
        String langString = context.getSession().getString((Object)"lang", "ZHS");
        ILocalizedMessageProvider localMsgProvider = msgProvider.getLocalizedMessageProvider(langString);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        ExcelExportImpl excelFactory = new ExcelExportImpl(localMsgProvider);
        if (!this.isEnableTask(parameter)) {
            HttpServletResponse response = ((HttpServiceInstance)svc).getResponse();
            String fileName = parameter.getString((Object)"_file_name_", "excel");
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("GBK");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes(), "ISO-8859-1") + ".xls\"");
            excelFactory.createExcel(this.getExportData(context), this.getColumnConfig(context), (OutputStream)response.getOutputStream(), context.getParameter().getChild(this.KEY_MERGE_COLUMN));
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String date = dateFormat.format(new Date());
            String fileName = parameter.getString((Object)"_file_name_", "excel_") + date + "_" + System.currentTimeMillis() + ".xls";
            File excel = new File(this.excelDir, fileName);
            if (excel.createNewFile()) {
                FileOutputStream os = new FileOutputStream(excel);
                try {
                    excelFactory.createExcel(this.getExportData(context), this.getColumnConfig(context), os, context.getParameter().getChild(this.KEY_MERGE_COLUMN));
                }
                finally {
                    if (os != null) {
                        os.flush();
                        ((OutputStream)os).close();
                    }
                }
            }
            parameter.put((Object)"file_path", (Object)excel.getCanonicalPath());
        }
        return 2;
    }

    CompositeMap getExportData(ServiceContext context) throws ServletException {
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        String return_path = (String)svc.getServiceConfigData().getObject("service-output/@output");
        if (return_path == null) {
            mLogger.log(Level.SEVERE, "service-output must be defined");
            throw new ServletException("service-output must be defined");
        }
        CompositeMap exportData = (CompositeMap)context.getObjectContext().getObject(return_path);
        return exportData;
    }

    CompositeMap getColumnConfig(ServiceContext context) throws ServletException {
        Iterator it;
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        CompositeMap column_config = (CompositeMap)context.getParameter().getObject("_column_config_/column");
        if (column_config == null) {
            mLogger.log(Level.SEVERE, "_column_config_ tag and column attibute must be defined");
            throw new ServletException("_column_config_ tag and column attibute must be defined");
        }
        CompositeMap contextMap = context.getObjectContext();
        CompositeMap datatype = (CompositeMap)contextMap.getObject("/_export_datatype");
        if (datatype != null && (it = datatype.getChildIterator()) != null) {
            while (it.hasNext()) {
                CompositeMap record = (CompositeMap)it.next();
                String name = record.getString((Object)"field");
                CompositeMap columnRecord = column_config.getChildByAttrib("record", (Object)"name", (Object)name);
                columnRecord.put((Object)"dataType", (Object)record.getString((Object)"dataType".toLowerCase()));
            }
        }
        return column_config;
    }

    private boolean isEnableTask(CompositeMap parameter) {
        if (parameter == null) {
            return false;
        }
        boolean enableTask = parameter.getBoolean((Object)KEY_ENABLETASK, false);
        return enableTask;
    }
}

