/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc.trace;

import uncertain.proc.IEntry;
import uncertain.proc.trace.IWithProcedureStackTrace;
import uncertain.proc.trace.TraceElement;

public class StackTraceManager {
    TraceElement rootNode;
    TraceElement currentNode;

    public StackTraceManager() {
        this.currentNode = this.rootNode = new TraceElement("service");
    }

    public StackTraceManager(TraceElement root) {
        this.rootNode = root;
        this.currentNode = root;
    }

    public TraceElement getCurrentNode() {
        return this.currentNode;
    }

    public TraceElement getRootNode() {
        return this.rootNode;
    }

    private TraceElement push(TraceElement element) {
        element.setParent(this.currentNode);
        this.currentNode.addChild(element);
        this.currentNode = element;
        return element;
    }

    public TraceElement enter(IEntry entry) {
        TraceElement element = new TraceElement(entry);
        return this.push(element);
    }

    public TraceElement enter(String node_name) {
        TraceElement element = new TraceElement(node_name);
        return this.push(element);
    }

    public TraceElement enter(TraceElement element) {
        return this.push(element);
    }

    public void fillException(Throwable thr) {
        IWithProcedureStackTrace wpt = null;
        if (thr instanceof IWithProcedureStackTrace) {
            wpt = (IWithProcedureStackTrace)((Object)thr);
        } else {
            Throwable cause = thr.getCause();
            if (cause != null && cause instanceof IWithProcedureStackTrace) {
                wpt = (IWithProcedureStackTrace)((Object)cause);
            }
        }
        if (wpt != null && this.currentNode != null && wpt.getTraceElement() == null) {
            wpt.setTraceElement(this.currentNode);
        }
    }

    public void exit() {
        if (this.currentNode == null) {
            throw new IllegalStateException("Root node already exited");
        }
        this.currentNode.setExitTime(System.currentTimeMillis());
        this.currentNode = this.currentNode.getParent();
    }
}

