/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import uncertain.core.ConfigurationError;
import uncertain.util.StringEnum;

public class Field {
    public static final String USAGE_INPUT = "input";
    public static final String USAGE_RETURN = "return";
    public static final String[] USAGE_VALUE_STRING = new String[]{"input", "return"};
    public static final StringEnum USAGE_VALUES = new StringEnum(USAGE_VALUE_STRING);
    String name;
    String path;
    String type;
    String usage;
    String description;
    Class type_class;
    int usage_value = -1;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.path == null) {
            this.path = '@' + name;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) throws ClassNotFoundException {
        this.type = t;
        if (this.type.indexOf(46) < 0) {
            this.type = "java.lang." + this.type;
        }
        this.type_class = Class.forName(this.type);
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage.toLowerCase();
        this.usage_value = USAGE_VALUES.valueOf(this.usage);
        if (!USAGE_VALUES.valid(this.usage_value)) {
            throw new ConfigurationError("Unknown usage value:" + usage);
        }
    }

    public boolean isReturnField() {
        return this.usage_value == 1;
    }

    public boolean isInputField() {
        return this.usage_value == 0;
    }

    public Field() {
    }

    public Field(String name, String type) throws ClassNotFoundException {
        this.setName(name);
        this.setType(type);
    }

    public Field(String name, Class type) {
        this.type_class = type;
        this.setName(type.getName());
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        StringBuffer desc = new StringBuffer();
        desc.append(this.type).append(' ').append(this.name);
        if (this.usage != null) {
            desc.append(' ').append(this.usage);
        }
        desc.append(':').append(this.path);
        if (this.description != null) {
            desc.append(':').append(this.description);
        }
        return desc.toString();
    }
}

