/*
 * Decompiled with CFR 0.152.
 */
package uncertain.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.core.IGlobalInstance;
import uncertain.event.Configuration;
import uncertain.event.IParticipantManager;
import uncertain.event.IServiceParticipant;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.ILoggerProvider;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.IObjectCreator;
import uncertain.ocm.IObjectRegistry;

public class ParticipantManager
extends AbstractLocatableObject
implements IParticipantManager,
IGlobalInstance,
IConfigurable {
    public static final String KEY_CATEGORY = "category";
    public static final String KEY_CLASS = "class";
    static final List EMPTY_LIST = Collections.unmodifiableList(new LinkedList());
    Map mParticipantsListMap;
    Map mParticipantConfigMap;
    IObjectRegistry mObjectRegistry;
    IObjectCreator mObjectCreator;
    ILogger mLogger;

    public ParticipantManager(IObjectRegistry objectRegistry, IObjectCreator objectCreator) {
        this.mObjectRegistry = objectRegistry;
        this.mObjectCreator = objectCreator;
        this.mParticipantsListMap = new HashMap();
        this.mParticipantConfigMap = new HashMap();
        ILoggerProvider p = LoggingContext.getLoggerProvider(this.mObjectRegistry);
        this.mLogger = p.getLogger("uncertain.core");
    }

    protected List getParticipantInstanceList(String category) {
        LinkedList lst = (LinkedList)this.mParticipantsListMap.get(category);
        if (lst == null) {
            lst = new LinkedList();
            this.mParticipantsListMap.put(category, lst);
        }
        return lst;
    }

    protected List getParticipantConfigList(String category) {
        LinkedList lst = (LinkedList)this.mParticipantConfigMap.get(category);
        if (lst == null) {
            lst = new LinkedList();
            this.mParticipantConfigMap.put(category, lst);
        }
        return lst;
    }

    @Override
    public List getParticipantList(String category) {
        return this.getParticipantInstanceList(category);
    }

    @Override
    public Configuration getParticipantsAsConfig(String category) {
        Configuration config = new Configuration();
        List participants = this.getParticipantList(category);
        if (participants != null) {
            Iterator it = participants.iterator();
            while (it.hasNext()) {
                config.addParticipant(it.next());
            }
        }
        return config;
    }

    @Override
    public void addParticipant(String category, Class instance_type) {
        this.getParticipantConfigList(category).add(instance_type);
    }

    Object createInstance(String cls_name) throws Exception {
        Class<?> cls = Class.forName(cls_name);
        Object participant = this.mObjectRegistry.getInstanceOfType(cls);
        if (participant == null) {
            participant = this.mObjectCreator.createInstance(cls);
        }
        return participant;
    }

    void loadConfigByCategory(CompositeMap config, String category) {
        List lst = this.getParticipantConfigList(category);
        Iterator it = config.getChildIterator();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap item = (CompositeMap)it.next();
                String cls_name = item.getString(KEY_CLASS);
                if (cls_name == null) {
                    throw BuiltinExceptionFactory.createAttributeMissing(this, KEY_CLASS);
                }
                try {
                    Class<?> cls = Class.forName(cls_name);
                    lst.add(cls);
                }
                catch (ClassNotFoundException ex) {
                    throw BuiltinExceptionFactory.createClassNotFoundException(this, cls_name);
                }
            }
        }
    }

    public void loadConfig(CompositeMap config) {
        Iterator it = config.getChildIterator();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap child = (CompositeMap)it.next();
                String category = child.getString(KEY_CATEGORY);
                if (category == null) {
                    throw BuiltinExceptionFactory.createAttributeMissing(this, KEY_CATEGORY);
                }
                this.loadConfigByCategory(child, category);
            }
        }
    }

    @Override
    public void beginConfigure(CompositeMap config) {
        this.loadConfig(config);
    }

    @Override
    public void endConfigure() {
    }

    @Override
    public void addIServiceParticipant(IServiceParticipant participant) {
        String scope = participant.getScope();
        List lst = this.getParticipantConfigList(scope);
        lst.add(participant);
    }

    public void onInitialize() throws Exception {
        Iterator cit = this.mParticipantConfigMap.entrySet().iterator();
        while (cit.hasNext()) {
            int num = 1;
            Map.Entry entry = cit.next();
            String category = entry.getKey().toString();
            List cls_list = (List)entry.getValue();
            this.mLogger.info("=========== Loading participant in {" + category + "} scope =============");
            LinkedList<Object> lst = new LinkedList<Object>();
            for (Class cls : cls_list) {
                this.mLogger.info("No." + num + " type=" + cls.getName());
                Object participant = this.mObjectRegistry.getInstanceOfType(cls);
                if (participant == null) {
                    participant = this.mObjectCreator.createInstance(cls);
                    this.mObjectRegistry.registerInstance(cls, participant);
                    this.mLogger.info("New instance created");
                } else {
                    this.mLogger.info("Got from global instance registry");
                }
                if (participant == null) {
                    throw new RuntimeException("Can't create instance of " + cls);
                }
                lst.add(participant);
                ++num;
            }
            this.mParticipantsListMap.put(category, lst);
        }
    }
}

