/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;

public class JSONAdaptor {
    public static final String DEFAULT_ROOT_ELEMENT_NAME = "object";
    public static final String DEFAULT_RECORD_NAME = "record";
    public static final String DEFAULT_ARRAY_NAME = "record";

    private static Object convert_internal(Object obj, String key) throws JSONException {
        if (obj instanceof JSONObject) {
            CompositeMap child = JSONAdaptor.toMap((JSONObject)obj, key);
            return child;
        }
        if (obj instanceof JSONArray) {
            JSONArray array = (JSONArray)obj;
            CompositeMap item = new CompositeMap(key);
            for (int i = 0; i < array.length(); ++i) {
                Object element = array.get(i);
                if (element instanceof JSONObject || element instanceof JSONArray) {
                    JSONAdaptor.add_internal(item, "record", element);
                    continue;
                }
                CompositeMap map = new CompositeMap(2);
                map.setName("record");
                map.put("value", element);
                item.addChild(map);
            }
            return item;
        }
        return obj;
    }

    private static CompositeMap add_internal(CompositeMap map, String key, Object value) throws JSONException {
        if (JSONObject.NULL.equals(value)) {
            map.put(key, (Object)null);
        } else if (value instanceof JSONObject || value instanceof JSONArray) {
            CompositeMap child = (CompositeMap)JSONAdaptor.convert_internal(value, key);
            map.addChild(child);
        } else {
            map.put(key, value);
        }
        return map;
    }

    public static CompositeMap toMap(JSONObject obj, CompositeMap map) {
        Iterator it = obj.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = null;
            try {
                value = obj.get(key);
                JSONAdaptor.add_internal(map, key, value);
            }
            catch (JSONException ex) {}
        }
        return map;
    }

    public static CompositeMap toMap(JSONObject obj, String root_element_name) {
        CompositeMap root = new CompositeMap(root_element_name);
        return JSONAdaptor.toMap(obj, root);
    }

    public static CompositeMap toMap(JSONObject obj) {
        return JSONAdaptor.toMap(obj, DEFAULT_ROOT_ELEMENT_NAME);
    }

    static Object toJSONObjectInternal(Object value) {
        if (value instanceof CompositeMap) {
            return JSONAdaptor.toJSONObject((CompositeMap)value);
        }
        if (value instanceof Collection) {
            Collection lst = (Collection)value;
            JSONArray array = new JSONArray();
            for (Object item : lst) {
                if (item instanceof Collection || item instanceof CompositeMap) {
                    array.put(JSONAdaptor.toJSONObjectInternal(item));
                    continue;
                }
                array.put(item);
            }
            return array;
        }
        return value;
    }

    public static JSONObject toJSONObject(CompositeMap map) {
        return JSONAdaptor.toJSONObject(map, null);
    }

    static void copyToJSON(CompositeMap map, JSONObject obj) {
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            value = JSONAdaptor.toJSONObjectInternal(value);
            try {
                Object key = entry.getKey();
                if (key == null) continue;
                obj.put(key.toString(), value);
            }
            catch (JSONException ex) {}
        }
    }

    public static JSONObject toJSONObject(CompositeMap map, Set<String> array_names) {
        JSONObject obj = new JSONObject();
        JSONAdaptor.copyToJSON(map, obj);
        Iterator it = map.getChildIterator();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap item = (CompositeMap)it.next();
                String name = item.getName();
                boolean as_array = false;
                if (array_names != null) {
                    if (array_names.contains(name)) {
                        as_array = true;
                    }
                } else if (item.size() == 0 && item.getChilds() != null) {
                    as_array = true;
                }
                try {
                    if (as_array) {
                        JSONArray array = new JSONArray();
                        Iterator cit = item.getChildIterator();
                        while (cit != null && cit.hasNext()) {
                            CompositeMap child = (CompositeMap)cit.next();
                            array.put(JSONAdaptor.toJSONObject(child));
                        }
                        obj.put(name, array);
                        continue;
                    }
                    JSONObject child = JSONAdaptor.toJSONObject(item);
                    obj.accumulate(name, child);
                }
                catch (JSONException ex) {}
            }
        }
        return obj;
    }

    public static JSONObject createJSONObject(InputStream is) throws IOException, JSONException {
        StringBuffer buf = new StringBuffer();
        int ch = is.read();
        while (ch != -1) {
            buf.append((char)ch);
            ch = is.read();
        }
        return new JSONObject(buf.toString());
    }

    public static void main(String[] args) throws Exception {
        JSONObject obj = new JSONObject();
        obj.put("name", "ABC");
        obj.put("address", "SH");
        JSONArray a = new JSONArray();
        a.put(1);
        a.put(true);
        obj.put("test", a);
        JSONObject o1 = new JSONObject();
        JSONObject o2 = new JSONObject();
        o1.put("valid", true);
        JSONArray b = new JSONArray();
        b.put("CONFIRM");
        b.put(o1);
        o2.put("result", 4.5);
        o2.put("result-list", b);
        obj.put("detail", o2);
        CompositeMap map = JSONAdaptor.toMap(obj);
        System.out.println(map.toXML());
        System.out.println(JSONAdaptor.toJSONObject(map));
    }
}

