/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.http;

import aurora.application.Version;
import aurora.service.http.HttpServiceFactory;
import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import uncertain.core.DirectoryConfig;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;

public class WebContextInit
implements ServletContextListener {
    public static final String KEY_UNCERTAIN_ENGINE = UncertainEngine.class.getName();
    UncertainEngine uncertainEngine;

    public static UncertainEngine getUncertainEngine(ServletContext context) {
        return (UncertainEngine)context.getAttribute(KEY_UNCERTAIN_ENGINE);
    }

    public void initUncertain(ServletContext servletContext) throws Exception {
        String config_dir = servletContext.getRealPath("/WEB-INF");
        String config_file = "uncertain.xml";
        this.uncertainEngine = new UncertainEngine(new File(config_dir), config_file);
        this.uncertainEngine.setName(servletContext.getServletContextName());
        DirectoryConfig dirConfig = this.uncertainEngine.getDirectoryConfig();
        dirConfig.setBaseDirectory(servletContext.getRealPath("/"));
        this.uncertainEngine.getPackageManager().loadPackageFromRootClassPath("aurora_builtin_package");
        IObjectRegistry os = this.uncertainEngine.getObjectRegistry();
        os.registerInstance(ServletContext.class, servletContext);
        this.uncertainEngine.startup();
        IObjectRegistry reg = this.uncertainEngine.getObjectRegistry();
        HttpServiceFactory fact = (HttpServiceFactory)reg.getInstanceOfType(HttpServiceFactory.class);
        if (fact == null) {
            fact = new HttpServiceFactory(this.uncertainEngine);
            fact.getCompositeLoader().setBaseDir(dirConfig.getBaseDirectory());
            reg.registerInstance(fact);
        }
    }

    public void init(ServletContext servlet_context) throws Exception {
        StringBuffer sb = new StringBuffer();
        StringBuffer line = new StringBuffer();
        sb.append("* ").append("Aurora-").append(Version.getVersion());
        sb.append("  |  ").append(servlet_context.getResource("/").toExternalForm());
        sb.append("  |  ").append(servlet_context.getServletContextName());
        sb.append(" *");
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            line.append("*");
        }
        System.out.println(line.toString());
        System.out.println(sb.toString());
        System.out.println(line.toString());
        this.initUncertain(servlet_context);
        servlet_context.setAttribute(KEY_UNCERTAIN_ENGINE, (Object)this.uncertainEngine);
    }

    public UncertainEngine getUncertainEngine() {
        return this.uncertainEngine;
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.uncertainEngine != null) {
            this.uncertainEngine.shutdown();
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            ServletContext context = event.getServletContext();
            this.init(context);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

