/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.JSONFunction;
import aurora.presentation.component.std.config.EventConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;

public class Chart
extends Component {
    public static String INPUT_TYPE = "inputtype";
    public static String DEFAULT_INPUT_TYPE = "input";
    private static final String PROPERTITY_SERIES_NAME = "seriesName";
    private static final String PROPERTITY_THEME = "chartTheme";
    private static final String PROPERTITY_CHART_ALIGNTICKS = "alignTicks";
    private static final String PROPERTITY_CHART_ANIMATION = "animation";
    private static final String PROPERTITY_CHART_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_CHART_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_CHART_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_CHART_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_CHART_CLASSNAME = "className";
    private static final String PROPERTITY_CHART_DEFAULTSERIESTYPE = "defaultSeriesType";
    private static final String PROPERTITY_CHART_IGNORE_HIDDEN_SERIES = "ignoreHiddenSeries";
    private static final String PROPERTITY_CHART_INVERTED = "inverted";
    private static final String PROPERTITY_CHART_MARGIN = "margin";
    private static final String PROPERTITY_CHART_MARGIN_TOP = "marginTop";
    private static final String PROPERTITY_CHART_MARGIN_RIGHT = "marginRight";
    private static final String PROPERTITY_CHART_MARGIN_LEFT = "marginLeft";
    private static final String PROPERTITY_CHART_MARGIN_BOTTOM = "marginBottom";
    private static final String PROPERTITY_CHART_PLOT_BACKGROUND_COLOR = "plotBackgroundColor";
    private static final String PROPERTITY_CHART_PLOT_BACKGROUND_IMAGE = "plotBackgroundImage";
    private static final String PROPERTITY_CHART_PLOT_BORDER_COLOR = "plotBorderColor";
    private static final String PROPERTITY_CHART_PLOT_BORDER_WIDTH = "plotBorderWidth";
    private static final String PROPERTITY_CHART_PLOT_SHADOW = "plotShadow";
    private static final String PROPERTITY_CHART_REFLOW = "reflow";
    private static final String PROPERTITY_CHART_RENDERTO = "renderTo";
    private static final String PROPERTITY_CHART_SELECTIONMARKERFILL = "selectionMarkerFill";
    private static final String PROPERTITY_CHART_SHADOW = "shadow";
    private static final String PROPERTITY_CHART_SHOW_AXES = "showAxes";
    private static final String PROPERTITY_CHART_SPACING_TOP = "spacingTop";
    private static final String PROPERTITY_CHART_SPACING_RIGHT = "spacingRight";
    private static final String PROPERTITY_CHART_SPACING_BOTTOM = "spacingBottom";
    private static final String PROPERTITY_CHART_SPACING_LEFT = "spacingLeft";
    private static final String PROPERTITY_CHART_STYLE = "chartStyle";
    private static final String PROPERTITY_CHART_TYPE = "type";
    private static final String PROPERTITY_CHART_ZOOMTYPE = "zoomType";
    private static final String PROPERTITY_CHART_POLAR = "polar";
    private static final String PROPERTITY_CHART_NAME_FIELD = "namefield";
    private static final String PROPERTITY_CHART_VALUE_FIELD = "valuefield";
    private static final String PROPERTITY_CREDITS = "credits";
    private static final String PROPERTITY_CREDITS_ENABLED = "enabled";
    private static final String PROPERTITY_POSITION = "position";
    private static final String PROPERTITY_POSITION_ALIGN = "align";
    private static final String PROPERTITY_POSITION_X = "x";
    private static final String PROPERTITY_POSITION_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_POSITION_Y = "y";
    private static final String PROPERTITY_CREDITS_HREF = "href";
    private static final String PROPERTITY_CREDITS_STYLE = "style";
    private static final String PROPERTITY_CREDITS_TEXT = "text";
    private static final String PROPERTITY_LABELS = "labels";
    private static final String PROPERTITY_LABELS_STYLE = "style";
    private static final String PROPERTITY_LABELS_LABEL_HTML = "html";
    private static final String PROPERTITY_LABELS_LABEL_STYLE = "style";
    private static final String PROPERTITY_LOADING = "loading";
    private static final String PROPERTITY_LOADING_HIDEDURATION = "hideDuration";
    private static final String PROPERTITY_LOADING_LABELSTYLE = "labelStyle";
    private static final String PROPERTITY_LOADING_SHOWDURATION = "showDuration";
    private static final String PROPERTITY_LOADING_STYLE = "style";
    private static final String PROPERTITY_LEGEND_ALIGN = "align";
    private static final String PROPERTITY_LEGEND_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_LEGEND_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_LEGEND_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_LEGEND_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_LEGEND_ENABLED = "enabled";
    private static final String PROPERTITY_LEGEND_FLOATING = "floating";
    private static final String PROPERTITY_LEGEND_ITEMSTYLE = "itemStyle";
    private static final String PROPERTITY_LEGEND_LAYOUT = "layout";
    private static final String PROPERTITY_LEGEND_LABELFORMATTER = "labelFormatter";
    private static final String PROPERTITY_LEGEND_MARGIN = "margin";
    private static final String PROPERTITY_LEGEND_REVERSED = "reversed";
    private static final String PROPERTITY_LEGEND_SHADOW = "shadow";
    private static final String PROPERTITY_LEGEND_STYLE = "style";
    private static final String PROPERTITY_LEGEND_SYMBOLPADDING = "symbolPadding";
    private static final String PROPERTITY_LEGEND_SYMBOLWIDTH = "symbolWidth";
    private static final String PROPERTITY_LEGEND_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_LEGEND_WIDTH = "width";
    private static final String PROPERTITY_LEGEND_X = "x";
    private static final String PROPERTITY_LEGEND_Y = "y";
    private static final String PROPERTITY_SUBTITLE_TEXT = "text";
    private static final String PROPERTITY_SUBTITLE_X = "x";
    private static final String PROPERTITY_SUBTITLE_Y = "y";
    private static final String PROPERTITY_SUBTITLE_ALIGN = "align";
    private static final String PROPERTITY_SUBTITLE_FLOATING = "floating";
    private static final String PROPERTITY_SUBTITLE_STYLE = "style";
    private static final String PROPERTITY_SUBTITLE_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_TITLE_TEXT = "text";
    private static final String PROPERTITY_TITLE_X = "x";
    private static final String PROPERTITY_TITLE_Y = "y";
    private static final String PROPERTITY_TITLE_ALIGN = "align";
    private static final String PROPERTITY_TITLE_MARGIN = "margin";
    private static final String PROPERTITY_TITLE_FLOATING = "floating";
    private static final String PROPERTITY_TITLE_STYLE = "style";
    private static final String PROPERTITY_TITLE_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_TOOLTIP = "tooltip";
    private static final String PROPERTITY_TOOLTIP_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_TOOLTIP_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_TOOLTIP_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_TOOLTIP_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_TOOLTIP_ENABLED = "enabled";
    private static final String PROPERTITY_TOOLTIP_FORMATTER = "formatter";
    private static final String PROPERTITY_TOOLTIP_HEADERFORMAT = "headerForamt";
    private static final String PROPERTITY_TOOLTIP_POINTFORMAT = "pointFormat";
    private static final String PROPERTITY_TOOLTIP_FOOTERFORMAT = "footerFormat";
    private static final String PROPERTITY_TOOLTIP_SHADOW = "shadow";
    private static final String PROPERTITY_TOOLTIP_SHARED = "shared";
    private static final String PROPERTITY_TOOLTIP_SNAP = "snap";
    private static final String PROPERTITY_TOOLTIP_STYLE = "style";
    private static final String PROPERTITY_EXPORTING = "exporting";
    private static final String PROPERTITY_EXPORTING_URL = "url";
    private static final String PROPERTITY_EXPORTING_ENABLED = "enabled";
    private static final String PROPERTITY_AXIS_X = "xAxis";
    private static final String PROPERTITY_AXIS_Y = "yAxis";
    private static final String PROPERTITY_AXIS_ALLOWDECIMALS = "allowDecimals";
    private static final String PROPERTITY_AXIS_ALTERNATEGRIDCOLOR = "alternateGridColor";
    private static final String PROPERTITY_AXIS_CATEGORIES = "categories";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS = "dateTimeLabelFormats";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_SECOND = "second";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_MINUTE = "minute";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_HOUR = "hour";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_DAY = "day";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_WEEK = "week";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_MONTH = "month";
    private static final String PROPERTITY_AXIS_DATETIMELABELFORMATS_YEAR = "year";
    private static final String PROPERTITY_AXIS_ENDONTICK = "endOnTick";
    private static final String PROPERTITY_AXIS_GRIDLINECOLOR = "gridLineColor";
    private static final String PROPERTITY_AXIS_GRIDLINEDASHSTYLE = "gridLineDashStyle";
    private static final String PROPERTITY_AXIS_GRIDLINEWIDTH = "gridLineWidth";
    private static final String PROPERTITY_AXIS_ID = "id";
    private static final String PROPERTITY_AXIS_LINECOLOR = "lineColor";
    private static final String PROPERTITY_AXIS_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_AXIS_LINKEDTO = "linkedTo";
    private static final String PROPERTITY_AXIS_MAX = "max";
    private static final String PROPERTITY_AXIS_MAXPADDING = "maxPadding";
    private static final String PROPERTITY_AXIS_MAXZOOM = "maxZoom";
    private static final String PROPERTITY_AXIS_MIN = "min";
    private static final String PROPERTITY_AXIS_MINORGRIDLINECOLOR = "minorGridLineColor";
    private static final String PROPERTITY_AXIS_MINORGRIDLINEDASHSTYLE = "minorGridLineDashStyle";
    private static final String PROPERTITY_AXIS_MINORGRIDLINEWIDTH = "minorGridLineWidth";
    private static final String PROPERTITY_AXIS_MINORTICKCOLOR = "minorTickColor";
    private static final String PROPERTITY_AXIS_MINORTICKINTERVAL = "minorTickInterval";
    private static final String PROPERTITY_AXIS_MINORTICKLENGTH = "minorTickLength";
    private static final String PROPERTITY_AXIS_MINORTICKPOSITION = "minorTickPosition";
    private static final String PROPERTITY_AXIS_MINORTICKWIDTH = "minorTickWidth";
    private static final String PROPERTITY_AXIS_MINPADDING = "minPadding";
    private static final String PROPERTITY_AXIS_MINRANGE = "minRange";
    private static final String PROPERTITY_AXIS_OFFSET = "offset";
    private static final String PROPERTITY_AXIS_OPPOSITE = "opposite";
    private static final String PROPERTITY_AXIS_PLOTBANDS = "plotBands";
    private static final String PROPERTITY_AXIS_PLOTBANDS_COLOR = "color";
    private static final String PROPERTITY_AXIS_PLOTBANDS_FROM = "from";
    private static final String PROPERTITY_AXIS_PLOTBANDS_ID = "id";
    private static final String PROPERTITY_AXIS_PLOTBANDS_TO = "to";
    private static final String PROPERTITY_AXIS_PLOTBANDS_ZINDEX = "zIndex";
    private static final String PROPERTITY_AXIS_PLOT_LABEL = "plotlabel";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_ALIGN = "align";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_TEXT = "text";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_RATATION = "rotation";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_STYLE = "style";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_TEXTALIGN = "textAlign";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_X = "x";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_Y = "y";
    private static final String PROPERTITY_AXIS_PLOTLINES = "plotLines";
    private static final String PROPERTITY_AXIS_PLOTLINES_COLOR = "color";
    private static final String PROPERTITY_AXIS_PLOTLINES_ID = "id";
    private static final String PROPERTITY_AXIS_PLOTLINES_VALUE = "value";
    private static final String PROPERTITY_AXIS_PLOTLINES_WIDTH = "width";
    private static final String PROPERTITY_AXIS_PLOTLINES_ZINDEX = "zIndex";
    private static final String PROPERTITY_AXIS_REVERSED = "reversed";
    private static final String PROPERTITY_AXIS_SHOWFIRSTLABEL = "showFirstLabel";
    private static final String PROPERTITY_AXIS_SHOWLASTLABEL = "showLastLabel";
    private static final String PROPERTITY_AXIS_STACKLABELS = "stackLabels";
    private static final String PROPERTITY_AXIS_STACKLABELS_ALIGN = "align";
    private static final String PROPERTITY_AXIS_STACKLABELS_TEXTALIGN = "textAlign";
    private static final String PROPERTITY_AXIS_STACKLABELS_VERTICALALIGH = "verticalAlign";
    private static final String PROPERTITY_AXIS_STACKLABELS_ENABLED = "enabled";
    private static final String PROPERTITY_AXIS_STACKLABELS_FORMATTER = "formatter";
    private static final String PROPERTITY_AXIS_STACKLABELS_STYLE = "style";
    private static final String PROPERTITY_AXIS_STACKLABELS_ROTATION = "rotation";
    private static final String PROPERTITY_AXIS_STACKLABELS_X = "x";
    private static final String PROPERTITY_AXIS_STACKLABELS_Y = "y";
    private static final String PROPERTITY_AXIS_STARTOFWEEK = "startOfWeek";
    private static final String PROPERTITY_AXIS_STARTONTICK = "startOnTick";
    private static final String PROPERTITY_AXIS_TICKCOLOR = "tickColor";
    private static final String PROPERTITY_AXIS_TICKINTERVAL = "tickInterval";
    private static final String PROPERTITY_AXIS_TICKLENGTH = "tickLength";
    private static final String PROPERTITY_AXIS_TICKMARKPLACEMENT = "tickmarkPlacement";
    private static final String PROPERTITY_AXIS_TICKPIXELINTERVAL = "tickPixelInterval";
    private static final String PROPERTITY_AXIS_TICKPOSITION = "tickPosition";
    private static final String PROPERTITY_AXIS_TICKWIDTH = "tickWidth";
    private static final String PROPERTITY_AXIS_TITLE = "title";
    private static final String PROPERTITY_AXIS_TITLE_ALIGN = "align";
    private static final String PROPERTITY_AXIS_TITLE_MARGIN = "margin";
    private static final String PROPERTITY_AXIS_TITLE_ROTATION = "rotation";
    private static final String PROPERTITY_AXIS_TITLE_STYLE = "style";
    private static final String PROPERTITY_AXIS_TITLE_TEXT = "text";
    private static final String PROPERTITY_AXIS_TYPE = "type";
    private static final String PROPERTITY_AXIS_LABELS = "labels";
    private static final String PROPERTITY_AXIS_LABELS_ALIGN = "align";
    private static final String PROPERTITY_AXIS_LABELS_FORMATTER = "formatter";
    private static final String PROPERTITY_AXIS_LABELS_ROTATION = "rotation";
    private static final String PROPERTITY_AXIS_LABELS_STAGGERLINES = "staggerLines";
    private static final String PROPERTITY_AXIS_LABELS_STEP = "step";
    private static final String PROPERTITY_AXIS_LABELS_STYLE = "style";
    private static final String PROPERTITY_AXIS_LABELS_X = "x";
    private static final String PROPERTITY_AXIS_LABELS_Y = "y";
    private static final String PROPERTITY_AXIS_NAME = "name";
    private static final String PROPERTITY_AXIS_BINDTARGET = "bindtarget";
    private static final String PROPERTITY_AXIS_STARTANGLE = "startAngle";
    private static final String PROPERTITY_AXIS_ENDANGLE = "endAngle";
    private static final String PROPERTITY_PLOTOPTIONS = "plotOptions";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER = "marker";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_ENABLED = "enabled";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_FILLCOLOR = "fillColor";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_LINECOLOR = "lineColor";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_RADIUS = "radius";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_SYMBOL = "symbol";
    private static final String PROPERTITY_PLOTOPTIONS_DASHSTYLE = "dashStyle";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS = "dataLabels";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_ALIGN = "align";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_COLOR = "color";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_BACKGROUND_COLOR = "backgroundColor";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_ENABLED = "enabled";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_FORMATTER = "formatter";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_ROTATION = "rotation";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_STYLE = "style";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_X = "x";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_Y = "y";
    private static final String PROPERTITY_PLOTOPTIONS_ALLOWPOINTSELECT = "allowPointSelect";
    private static final String PROPERTITY_PLOTOPTIONS_ANIMATION = "animation";
    private static final String PROPERTITY_PLOTOPTIONS_CONNECTNULLS = "connectNulls";
    private static final String PROPERTITY_PLOTOPTIONS_CROPTHRESHOLD = "cropThreshold";
    private static final String PROPERTITY_PLOTOPTIONS_COLOR = "color";
    private static final String PROPERTITY_PLOTOPTIONS_CURSOR = "cursor";
    private static final String PROPERTITY_PLOTOPTIONS_ENABLEMOUSETRACKING = "enableMouseTracking";
    private static final String PROPERTITY_PLOTOPTIONS_ID = "id";
    private static final String PROPERTITY_PLOTOPTIONS_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_PLOTOPTIONS_POINT = "point";
    private static final String PROPERTITY_PLOTOPTIONS_POINTSTART = "pointStart";
    private static final String PROPERTITY_PLOTOPTIONS_POINTINTERVAL = "pointInterval";
    private static final String PROPERTITY_PLOTOPTIONS_SELECTED = "selected";
    private static final String PROPERTITY_PLOTOPTIONS_SHADOW = "shadow";
    private static final String PROPERTITY_PLOTOPTIONS_SHOWCHECKBOX = "showCheckbox";
    private static final String PROPERTITY_PLOTOPTIONS_SHOWINLEGEND = "showInLegend";
    private static final String PROPERTITY_PLOTOPTIONS_STACKING = "stacking";
    private static final String PROPERTITY_PLOTOPTIONS_STATES = "states";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_HOVER = "hover";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_SELECT = "select";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_ENABLED = "enabled";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_FILLCOLOR = "fillColor";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_LINECOLOR = "lineColor";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_RADIUS = "radius";
    private static final String PROPERTITY_PLOTOPTIONS_STATES_HOVER_BRIGHTNESS = "brightness";
    private static final String PROPERTITY_PLOTOPTIONS_STICKYTRACKING = "stickyTracking";
    private static final String PROPERTITY_PLOTOPTIONS_TURBOTHRESHOLD = "turboThreshold";
    private static final String PROPERTITY_PLOTOPTIONS_VISIBLE = "visible";
    private static final String PROPERTITY_PLOTOPTIONS_ZINDEX = "zIndex";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN = "column";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_COLORBYPOINT = "colorByPoint";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_GROUPPADDING = "groupPadding";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_MINPOINTLENGTH = "minPointLength";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_POINTPADDING = "pointPadding";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_POINTWIDTH = "pointWidth";
    private static final String PROPERTITY_PLOTOPTIONS_AREA = "area";
    private static final String PROPERTITY_PLOTOPTIONS_AREA_FILLCOLOR = "fillColor";
    private static final String PROPERTITY_PLOTOPTIONS_AREA_FILLOPACITY = "fillOpacity";
    private static final String PROPERTITY_PLOTOPTIONS_AREA_LINECOLOR = "lineColor";
    private static final String PROPERTITY_PLOTOPTIONS_AREA_THRESHOLD = "threshold";
    private static final String PROPERTITY_PLOTOPTIONS_PIE = "pie";
    private static final String PROPERTITY_PLOTOPTIONS_PIE_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_PLOTOPTIONS_PIE_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_PLOTOPTIONS_PIE_CENTER = "center";
    private static final String PROPERTITY_PLOTOPTIONS_PIE_INNERSIZE = "innerSize";
    private static final String PROPERTITY_PLOTOPTIONS_PIE_SIZE = "size";
    private static final String PROPERTITY_PLOTOPTIONS_PIE_SLICEDOFFSET = "slicedOffset";
    private static final String PROPERTITY_PLOTOPTIONS_SCATTER = "scatter";
    private static final String PROPERTITY_PLOTOPTIONS_LINE = "line";
    private static final String PROPERTITY_PLOTOPTIONS_LINE_STEP = "step";
    private static final String PROPERTITY_PLOTOPTIONS_AREASPLINE = "areaspline";
    private static final String PROPERTITY_PLOTOPTIONS_SPLINE = "spline";
    private static final String PROPERTITY_PLOTOPTIONS_BAR = "bar";
    private static final String PROPERTITY_PLOTOPTIONS_SERIES = "series";

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        CompositeMap view = context.getView();
        String theme = view.getString(PROPERTITY_THEME.toLowerCase());
        if (theme == null) {
            theme = "grid";
        }
        this.addJavaScript(session, context, "chart/Animate-min.js");
        this.addJavaScript(session, context, "chart/Adapter-min.js");
        this.addJavaScript(session, context, "chart/Chart-min.js");
        if (!view.getBoolean(PROPERTITY_CHART_POLAR, false) && this.hasPolarType(view)) {
            view.put(PROPERTITY_CHART_POLAR, new Boolean(true));
            this.addJavaScript(session, context, "chart/Chart-more-min.js");
        }
        this.addJavaScript(session, context, "chart/themes/" + theme + ".js");
        this.addJavaScript(session, context, "chart/Exporting-min.js");
    }

    private boolean hasPolarType(CompositeMap view) {
        Iterator childs = view.getChildIterator();
        if (null != childs) {
            while (childs.hasNext()) {
                CompositeMap child = (CompositeMap)childs.next();
                if (!("chart".equals(child.getName()) ? PROPERTITY_CHART_POLAR.equals(child.getString("type".toLowerCase())) : this.hasPolarType(child))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addEvent(String id, String eventName, String handler) {
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        String bindTarget = view.getString(PROPERTITY_AXIS_BINDTARGET);
        map.put(PROPERTITY_AXIS_BINDTARGET, bindTarget);
        String value = view.getString(PROPERTITY_SERIES_NAME.toLowerCase());
        if (value == null) {
            value = PROPERTITY_AXIS_NAME;
        }
        this.addConfig(PROPERTITY_SERIES_NAME, value);
        map.put("contextPath", model.getObject("/request/@context_path").toString());
        this.processChartConfig(context);
        JSONObject config = this.getConfig();
        config.remove("height");
        config.remove("width");
        config.remove("listeners");
        map.put("config", this.getConfigString());
    }

    private void putStringCfg(CompositeMap view, String key, Map map) {
        String value = view.getString(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putIntCfg(CompositeMap view, String key, Map map) {
        Integer value = view.getInt(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putFloatCfg(CompositeMap view, String key, Map map) {
        Float value = view.getFloat(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putLongCfg(CompositeMap view, String key, Map map) {
        Long value = view.getLong(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putBooleanCfg(CompositeMap view, String key, Map map) {
        Boolean value = view.getBoolean(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putFunctionCfg(CompositeMap view, String key, Map map) {
        String value = view.getString(key.toLowerCase());
        if (value != null) {
            map.put(key, new JSONFunction(value));
        }
    }

    private void putArrayCfg(CompositeMap view, String key, Map map) {
        String value = view.getString(key.toLowerCase());
        if (value != null) {
            try {
                JSONArray arr = new JSONArray("[" + value + "]");
                map.put(key, arr);
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
    }

    private void putStyleCfg(CompositeMap view, String key, Map map) {
        String value = view.getString(key.toLowerCase());
        if (value != null) {
            JSONObject smap = new JSONObject();
            String[] sts = value.split(";");
            for (int i = 0; i < sts.length; ++i) {
                String style = sts[i];
                if ("".equals(style) || style.indexOf(":") == -1) continue;
                String[] vs = style.split(":");
                String k = vs[0];
                String v = vs[1];
                v = v.replaceAll("'", "");
                Integer iv = null;
                try {
                    iv = Integer.valueOf(v);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (iv == null) {
                        smap.put(k, v);
                        continue;
                    }
                    smap.put(k, iv);
                    continue;
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            if (PROPERTITY_CHART_STYLE.equals(key)) {
                key = "style";
            }
            map.put(key, smap);
        }
    }

    private void putColorCfg(CompositeMap parent, String key, Map map) {
        HashMap cfg = new HashMap();
        String linearGradient = "linearGradient";
        String stops = "stops";
        CompositeMap view = parent.getChild(key);
        if (view != null) {
            this.putArrayCfg(view, linearGradient, cfg);
            this.putArrayCfg(view, stops, cfg);
            if (!cfg.isEmpty()) {
                map.put(key, new JSONObject(cfg));
            }
        } else {
            this.putStringCfg(parent, key, map);
        }
    }

    private void processChartConfig(ViewContext context) {
        HashMap<String, Object> chart = new HashMap<String, Object>();
        CompositeMap view = context.getView();
        Map map = context.getMap();
        chart.put(PROPERTITY_CHART_RENDERTO, (String)map.get("id") + "_c");
        String value = view.getString("type".toLowerCase());
        if (PROPERTITY_CHART_POLAR.equals(value)) {
            chart.put("type", PROPERTITY_PLOTOPTIONS_LINE);
            chart.put(PROPERTITY_CHART_POLAR, new Boolean(true));
        } else {
            this.putStringCfg(view, "type", chart);
        }
        this.putBooleanCfg(view, PROPERTITY_CHART_ALIGNTICKS, chart);
        this.putBooleanCfg(view, "animation", chart);
        this.putColorCfg(view, "backgroundColor", chart);
        this.putFloatCfg(view, "borderRadius", chart);
        this.putStringCfg(view, "borderColor", chart);
        this.putFloatCfg(view, "borderWidth", chart);
        this.putStringCfg(view, PROPERTITY_CHART_CLASSNAME, chart);
        this.putLongCfg(view, "height", chart);
        this.putStringCfg(view, PROPERTITY_CHART_DEFAULTSERIESTYPE, chart);
        this.putBooleanCfg(view, PROPERTITY_CHART_IGNORE_HIDDEN_SERIES, chart);
        this.putBooleanCfg(view, PROPERTITY_CHART_INVERTED, chart);
        this.putArrayCfg(view, "margin", chart);
        this.putIntCfg(view, PROPERTITY_CHART_MARGIN_TOP, chart);
        this.putIntCfg(view, PROPERTITY_CHART_MARGIN_RIGHT, chart);
        this.putIntCfg(view, PROPERTITY_CHART_MARGIN_LEFT, chart);
        this.putIntCfg(view, PROPERTITY_CHART_MARGIN_BOTTOM, chart);
        this.putColorCfg(view, PROPERTITY_CHART_PLOT_BACKGROUND_COLOR, chart);
        this.putStringCfg(view, PROPERTITY_CHART_PLOT_BACKGROUND_IMAGE, chart);
        this.putStringCfg(view, PROPERTITY_CHART_PLOT_BORDER_COLOR, chart);
        this.putFloatCfg(view, PROPERTITY_CHART_PLOT_BORDER_WIDTH, chart);
        this.putBooleanCfg(view, PROPERTITY_CHART_PLOT_SHADOW, chart);
        this.putBooleanCfg(view, PROPERTITY_CHART_REFLOW, chart);
        this.putStringCfg(view, PROPERTITY_CHART_SELECTIONMARKERFILL, chart);
        this.putBooleanCfg(view, "shadow", chart);
        this.putBooleanCfg(view, PROPERTITY_CHART_SHOW_AXES, chart);
        this.putIntCfg(view, PROPERTITY_CHART_SPACING_TOP, chart);
        this.putIntCfg(view, PROPERTITY_CHART_SPACING_RIGHT, chart);
        this.putIntCfg(view, PROPERTITY_CHART_SPACING_BOTTOM, chart);
        this.putIntCfg(view, PROPERTITY_CHART_SPACING_LEFT, chart);
        this.putStyleCfg(view, PROPERTITY_CHART_STYLE, chart);
        this.putLongCfg(view, "height", chart);
        this.putStringCfg(view, PROPERTITY_CHART_ZOOMTYPE, chart);
        this.putStringCfg(view, PROPERTITY_CHART_NAME_FIELD, chart);
        this.putStringCfg(view, PROPERTITY_CHART_VALUE_FIELD, chart);
        this.putEvents(view, chart);
        this.addConfig("chart", new JSONObject(chart));
        this.processCredits(view);
        this.processLabels(view);
        this.processLegend(view);
        this.processLoading(view);
        this.processPlotOptions(view);
        this.processSubTitle(view);
        this.processTitle(view);
        this.processTooltip(view);
        this.processExporting(view);
        this.createAxis(view, PROPERTITY_AXIS_X);
        this.createAxis(view, PROPERTITY_AXIS_Y);
    }

    private void putEvents(CompositeMap view, Map map) {
        List list;
        CompositeMap events = view.getChild("events");
        if (events != null && (list = events.getChilds()) != null) {
            JSONObject eo = new JSONObject();
            for (CompositeMap event : list) {
                EventConfig eventConfig = EventConfig.getInstance(event);
                String eventName = eventConfig.getEventName();
                String handler = eventConfig.getHandler();
                if ("".equals(eventName) || "".equals(handler)) continue;
                try {
                    eo.put(eventName, new JSONFunction(handler));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            map.put("events", eo);
        }
    }

    private void processTitle(CompositeMap parent) {
        HashMap title = new HashMap();
        CompositeMap view = parent.getChild(PROPERTITY_AXIS_TITLE);
        if (view != null) {
            this.putStyleCfg(view, "style", title);
            this.putStringCfg(view, "text", title);
            this.putIntCfg(view, "x", title);
            this.putIntCfg(view, "y", title);
            this.putStringCfg(view, "align", title);
            this.putIntCfg(view, "margin", title);
            this.putBooleanCfg(view, "floating", title);
            this.putStringCfg(view, "verticalAlign", title);
        }
        if (!title.isEmpty()) {
            this.addConfig(PROPERTITY_AXIS_TITLE, new JSONObject(title));
        }
    }

    private void processSubTitle(CompositeMap parent) {
        HashMap title = new HashMap();
        CompositeMap view = parent.getChild("subtitle");
        if (view != null) {
            this.putStyleCfg(view, "style", title);
            this.putStringCfg(view, "text", title);
            this.putIntCfg(view, "x", title);
            this.putIntCfg(view, "y", title);
            this.putBooleanCfg(view, "floating", title);
            this.putStringCfg(view, "align", title);
            this.putBooleanCfg(view, "floating", title);
            this.putStringCfg(view, "verticalAlign", title);
        }
        if (!title.isEmpty()) {
            this.addConfig("subtitle", new JSONObject(title));
        }
    }

    private void processLegend(CompositeMap parent) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild("legend");
        if (view != null) {
            this.putStyleCfg(view, PROPERTITY_LEGEND_ITEMSTYLE, cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putStringCfg(view, "align", cfg);
            this.putStringCfg(view, "backgroundColor", cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putFloatCfg(view, "borderWidth", cfg);
            this.putFloatCfg(view, "borderRadius", cfg);
            this.putBooleanCfg(view, "enabled", cfg);
            this.putBooleanCfg(view, "floating", cfg);
            this.putStringCfg(view, PROPERTITY_LEGEND_LAYOUT, cfg);
            this.putFunctionCfg(view, PROPERTITY_LEGEND_LABELFORMATTER, cfg);
            this.putIntCfg(view, "margin", cfg);
            this.putBooleanCfg(view, "reversed", cfg);
            this.putBooleanCfg(view, "shadow", cfg);
            this.putIntCfg(view, PROPERTITY_LEGEND_SYMBOLPADDING, cfg);
            this.putIntCfg(view, PROPERTITY_LEGEND_SYMBOLWIDTH, cfg);
            this.putStringCfg(view, "verticalAlign", cfg);
            this.putIntCfg(view, "width", cfg);
            this.putIntCfg(view, "x", cfg);
            this.putIntCfg(view, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            this.addConfig("legend", new JSONObject(cfg));
        }
    }

    private void processPlotOptions(CompositeMap parent) {
        List children;
        HashMap<String, JSONObject> cfg = new HashMap<String, JSONObject>();
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS);
        if (view != null && (children = view.getChilds()) != null) {
            for (CompositeMap option : children) {
                String name = option.getName().toLowerCase();
                if (PROPERTITY_PLOTOPTIONS_LINE.equals(name)) {
                    cfg.put(name, this.processPlotLine(option));
                    continue;
                }
                if (PROPERTITY_PLOTOPTIONS_SPLINE.equals(name)) {
                    cfg.put(name, this.processPlotSeries(option));
                    continue;
                }
                if (PROPERTITY_PLOTOPTIONS_BAR.equals(name)) {
                    cfg.put(name, this.processPlotColumn(option));
                    continue;
                }
                if (PROPERTITY_PLOTOPTIONS_COLUMN.equals(name)) {
                    cfg.put(name, this.processPlotColumn(option));
                    continue;
                }
                if (PROPERTITY_PLOTOPTIONS_AREA.equals(name)) {
                    cfg.put(name, this.processPlotArea(option));
                    continue;
                }
                if (PROPERTITY_PLOTOPTIONS_AREASPLINE.equals(name)) {
                    cfg.put(name, this.processPlotArea(option));
                    continue;
                }
                if (PROPERTITY_PLOTOPTIONS_PIE.equals(name)) {
                    cfg.put(name, this.processPlotPie(option));
                    continue;
                }
                if (PROPERTITY_PLOTOPTIONS_SERIES.equals(name)) {
                    cfg.put(name, this.processPlotSeries(option));
                    continue;
                }
                if (!PROPERTITY_PLOTOPTIONS_SCATTER.equals(name)) continue;
                cfg.put(name, this.processPlotSeries(option));
            }
        }
        if (!cfg.isEmpty()) {
            this.addConfig(PROPERTITY_PLOTOPTIONS, new JSONObject(cfg));
        }
    }

    private JSONObject processPlotLine(CompositeMap view) {
        HashMap cfg = new HashMap();
        this.putIntCfg(view, "step", cfg);
        this.processPlot(view, cfg);
        return new JSONObject(cfg);
    }

    private JSONObject processPlotColumn(CompositeMap view) {
        HashMap cfg = new HashMap();
        this.putStringCfg(view, "borderColor", cfg);
        this.putFloatCfg(view, "borderRadius", cfg);
        this.putFloatCfg(view, "borderWidth", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_COLUMN_COLORBYPOINT, cfg);
        this.putFloatCfg(view, PROPERTITY_PLOTOPTIONS_COLUMN_GROUPPADDING, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_COLUMN_MINPOINTLENGTH, cfg);
        this.putFloatCfg(view, PROPERTITY_PLOTOPTIONS_COLUMN_POINTPADDING, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_COLUMN_POINTWIDTH, cfg);
        this.putEvents(view, cfg);
        this.processPlot(view, cfg);
        return new JSONObject(cfg);
    }

    private JSONObject processPlotArea(CompositeMap view) {
        HashMap cfg = new HashMap();
        this.putColorCfg(view, "fillColor", cfg);
        this.putFloatCfg(view, PROPERTITY_PLOTOPTIONS_AREA_FILLOPACITY, cfg);
        this.putStringCfg(view, "lineColor", cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_AREA_THRESHOLD, cfg);
        this.processPlot(view, cfg);
        return new JSONObject(cfg);
    }

    private JSONObject processPlotPie(CompositeMap view) {
        HashMap cfg = new HashMap();
        this.putStringCfg(view, "borderColor", cfg);
        this.putIntCfg(view, "borderWidth", cfg);
        this.putArrayCfg(view, PROPERTITY_PLOTOPTIONS_PIE_CENTER, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_PIE_INNERSIZE, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_PIE_SIZE, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_PIE_SLICEDOFFSET, cfg);
        this.processPlot(view, cfg);
        return new JSONObject(cfg);
    }

    private JSONObject processPlotSeries(CompositeMap view) {
        HashMap cfg = new HashMap();
        this.processPlot(view, cfg);
        return new JSONObject(cfg);
    }

    private void processPlot(CompositeMap view, Map cfg) {
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ALLOWPOINTSELECT, cfg);
        this.putBooleanCfg(view, "animation", cfg);
        this.putStringCfg(view, "color", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_CONNECTNULLS, cfg);
        this.putLongCfg(view, PROPERTITY_PLOTOPTIONS_CROPTHRESHOLD, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_CURSOR, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_DASHSTYLE, cfg);
        this.processPlotDataLabels(view, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ENABLEMOUSETRACKING, cfg);
        this.putEvents(view, cfg);
        this.putStringCfg(view, "id", cfg);
        this.putFloatCfg(view, "lineWidth", cfg);
        this.processPlotMarker(view, cfg, true);
        this.processPlotPoint(view, cfg);
        this.putLongCfg(view, PROPERTITY_PLOTOPTIONS_POINTSTART, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_POINTINTERVAL, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SELECTED, cfg);
        this.putBooleanCfg(view, "shadow", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWCHECKBOX, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWINLEGEND, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_STACKING, cfg);
        this.processPlotStates(view, cfg, false);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_STICKYTRACKING, cfg);
        this.putLongCfg(view, PROPERTITY_PLOTOPTIONS_TURBOTHRESHOLD, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_VISIBLE, cfg);
        this.putIntCfg(view, "zIndex", cfg);
    }

    private void processPlotMarker(CompositeMap parent, Map map, boolean includeStates) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_MARKER);
        HashMap cfg = new HashMap();
        if (view != null) {
            this.putBooleanCfg(view, "enabled", cfg);
            this.putStringCfg(view, "fillColor", cfg);
            this.putStringCfg(view, "lineColor", cfg);
            this.putFloatCfg(view, "lineWidth", cfg);
            this.putFloatCfg(view, "radius", cfg);
            if (includeStates) {
                this.processPlotStates(view, cfg, true);
            }
            this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_MARKER_SYMBOL, cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_PLOTOPTIONS_MARKER, new JSONObject(cfg));
        }
    }

    private void processPlotStates(CompositeMap parent, Map map, boolean underMarker) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_STATES);
        HashMap cfg = new HashMap();
        if (view != null) {
            this.processPlotStatesHover(view, cfg, !underMarker);
            if (underMarker) {
                this.processPlotStatesSelect(view, cfg);
            }
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_PLOTOPTIONS_STATES, new JSONObject(cfg));
        }
    }

    private void processPlotStatesHover(CompositeMap parent, Map map, boolean includeMaker) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_STATES_HOVER);
        HashMap cfg = new HashMap();
        if (null != view) {
            this.putBooleanCfg(view, "enabled", cfg);
            this.putFloatCfg(view, "lineWidth", cfg);
            if (includeMaker) {
                this.putFloatCfg(view, PROPERTITY_PLOTOPTIONS_STATES_HOVER_BRIGHTNESS, cfg);
                this.processPlotMarker(view, cfg, false);
            } else {
                this.putStringCfg(view, "fillColor", cfg);
                this.putStringCfg(view, "lineColor", cfg);
                this.putFloatCfg(view, "radius", cfg);
            }
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_PLOTOPTIONS_STATES_HOVER, new JSONObject(cfg));
        }
    }

    private void processPlotStatesSelect(CompositeMap parent, Map map) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_STATES_SELECT);
        HashMap cfg = new HashMap();
        if (null != view) {
            this.putBooleanCfg(view, "enabled", cfg);
            this.putStringCfg(view, "fillColor", cfg);
            this.putStringCfg(view, "lineColor", cfg);
            this.putFloatCfg(view, "lineWidth", cfg);
            this.putFloatCfg(view, "radius", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_PLOTOPTIONS_STATES_SELECT, new JSONObject(cfg));
        }
    }

    private void processPlotPoint(CompositeMap parent, Map map) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_POINT);
        if (view != null) {
            this.putEvents(view, map);
        }
    }

    private void processPlotDataLabels(CompositeMap parent, Map map) {
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_DATALABELS);
        HashMap cfg = new HashMap();
        if (view != null) {
            this.putStringCfg(view, "align", cfg);
            this.putStringCfg(view, "color", cfg);
            this.putStringCfg(view, "backgroundColor", cfg);
            this.putBooleanCfg(view, "enabled", cfg);
            this.putFunctionCfg(view, "formatter", cfg);
            this.putIntCfg(view, "rotation", cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putIntCfg(view, "x", cfg);
            this.putIntCfg(view, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_PLOTOPTIONS_DATALABELS, new JSONObject(cfg));
        }
    }

    private void processTooltip(CompositeMap parent) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild(PROPERTITY_TOOLTIP);
        if (view != null) {
            this.putStringCfg(view, "backgroundColor", cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putIntCfg(view, "borderRadius", cfg);
            this.putIntCfg(view, "borderWidth", cfg);
            this.putBooleanCfg(view, "enabled", cfg);
            this.putFunctionCfg(view, "formatter", cfg);
            this.putStringCfg(view, PROPERTITY_TOOLTIP_HEADERFORMAT, cfg);
            this.putStringCfg(view, PROPERTITY_TOOLTIP_POINTFORMAT, cfg);
            this.putStringCfg(view, PROPERTITY_TOOLTIP_FOOTERFORMAT, cfg);
            this.putBooleanCfg(view, "shadow", cfg);
            this.putBooleanCfg(view, PROPERTITY_TOOLTIP_SHARED, cfg);
            this.putIntCfg(view, PROPERTITY_TOOLTIP_SNAP, cfg);
            this.putStyleCfg(view, "style", cfg);
        }
        if (!cfg.isEmpty()) {
            this.addConfig(PROPERTITY_TOOLTIP, new JSONObject(cfg));
        }
    }

    private void processCredits(CompositeMap parent) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild(PROPERTITY_CREDITS);
        if (view != null) {
            this.putBooleanCfg(view, "enabled", cfg);
            this.processCreditsPosition(view, cfg);
            this.putStringCfg(view, PROPERTITY_CREDITS_HREF, cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putStringCfg(view, "text", cfg);
        }
        if (!cfg.isEmpty()) {
            this.addConfig(PROPERTITY_CREDITS, new JSONObject(cfg));
        }
    }

    private void processCreditsPosition(CompositeMap parent, Map map) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild(PROPERTITY_POSITION);
        if (view != null) {
            this.putStringCfg(view, "align", cfg);
            this.putIntCfg(view, "x", cfg);
            this.putStringCfg(view, "verticalAlign", cfg);
            this.putIntCfg(view, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_POSITION, new JSONObject(cfg));
        }
    }

    private void processLabels(CompositeMap parent) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild("labels");
        JSONArray array = null;
        if (view != null) {
            this.putStyleCfg(view, "style", cfg);
            List list = view.getChilds();
            if (list != null) {
                array = new JSONArray();
                for (CompositeMap label : list) {
                    HashMap icfg = new HashMap();
                    this.putStringCfg(label, PROPERTITY_LABELS_LABEL_HTML, icfg);
                    this.putStyleCfg(label, "style", icfg);
                    array.put(icfg);
                }
            }
        }
        if (array != null) {
            this.addConfig("labels", array);
        }
    }

    private void processExporting(CompositeMap parent) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild(PROPERTITY_EXPORTING);
        if (view != null) {
            this.putStringCfg(view, PROPERTITY_EXPORTING_URL, cfg);
            this.putBooleanCfg(view, "enabled", cfg);
        }
        if (!cfg.isEmpty()) {
            this.addConfig(PROPERTITY_EXPORTING, new JSONObject(cfg));
        }
    }

    private void processLoading(CompositeMap parent) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild(PROPERTITY_LOADING);
        if (view != null) {
            this.putLongCfg(view, PROPERTITY_LOADING_HIDEDURATION, cfg);
            this.putStyleCfg(view, PROPERTITY_LOADING_LABELSTYLE, cfg);
            this.putLongCfg(view, PROPERTITY_LOADING_SHOWDURATION, cfg);
            this.putStyleCfg(view, "style", cfg);
        }
        if (!cfg.isEmpty()) {
            this.addConfig(PROPERTITY_LOADING, new JSONObject(cfg));
        }
    }

    private void createLabels(CompositeMap cview, Map map) {
        CompositeMap view = cview.getChild("labels");
        HashMap cfg = new HashMap();
        if (view != null) {
            this.putStringCfg(view, "align", cfg);
            this.putFunctionCfg(view, "formatter", cfg);
            this.putIntCfg(view, "rotation", cfg);
            this.putIntCfg(view, PROPERTITY_AXIS_LABELS_STAGGERLINES, cfg);
            this.putIntCfg(view, "step", cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putIntCfg(view, "x", cfg);
            this.putIntCfg(view, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put("labels", new JSONObject(cfg));
        }
    }

    private void createAxis(CompositeMap parent, String name) {
        CompositeMap axis = parent.getChild(name);
        if (axis != null) {
            List list = axis.getChilds();
            JSONArray array = null;
            if (list != null) {
                array = new JSONArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    HashMap cfg = new HashMap();
                    CompositeMap axi = (CompositeMap)it.next();
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_ALLOWDECIMALS, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_ALTERNATEGRIDCOLOR, cfg);
                    this.putArrayCfg(axi, PROPERTITY_AXIS_CATEGORIES, cfg);
                    this.createDateTimeLabelFormats(axi, cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_ENDONTICK, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_GRIDLINECOLOR, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_GRIDLINEDASHSTYLE, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_GRIDLINEWIDTH, cfg);
                    this.putStringCfg(axi, "id", cfg);
                    this.createLabels(axi, cfg);
                    this.putStringCfg(axi, "lineColor", cfg);
                    this.putFloatCfg(axi, "lineWidth", cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_LINKEDTO, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_MAX, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_MAXPADDING, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_MAXZOOM, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_MIN, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_MINORGRIDLINECOLOR, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_MINORGRIDLINEDASHSTYLE, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_MINORGRIDLINEWIDTH, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_MINORTICKCOLOR, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_MINORTICKINTERVAL, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_MINORTICKLENGTH, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_MINORTICKPOSITION, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_MINORTICKWIDTH, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_MINRANGE, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_MINPADDING, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_OFFSET, cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_OPPOSITE, cfg);
                    this.creatPlotBands(axi, cfg);
                    this.creatPlotLines(axi, cfg);
                    this.putBooleanCfg(axi, "reversed", cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_SHOWFIRSTLABEL, cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_SHOWLASTLABEL, cfg);
                    if (PROPERTITY_AXIS_Y.equals(name)) {
                        this.createStackLabels(axi, cfg);
                    }
                    this.putIntCfg(axi, PROPERTITY_AXIS_STARTOFWEEK, cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_STARTONTICK, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_TICKCOLOR, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_TICKINTERVAL, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_TICKLENGTH, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_TICKMARKPLACEMENT, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_TICKPIXELINTERVAL, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_TICKPOSITION, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_TICKWIDTH, cfg);
                    this.putStringCfg(axi, "lineColor", cfg);
                    this.createTitle(axi, cfg);
                    this.putStringCfg(axi, "type", cfg);
                    this.putEvents(axi, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_NAME, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_BINDTARGET, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_STARTANGLE, cfg);
                    this.putFloatCfg(axi, PROPERTITY_AXIS_ENDANGLE, cfg);
                    array.put(cfg);
                }
                if (array != null) {
                    this.addConfig(name, array);
                }
            }
        }
    }

    private void createDateTimeLabelFormats(CompositeMap view, Map map) {
        CompositeMap formats = view.getChild(PROPERTITY_AXIS_DATETIMELABELFORMATS);
        HashMap cfg = new HashMap();
        if (formats != null) {
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_SECOND, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_MINUTE, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_HOUR, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_DAY, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_WEEK, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_MONTH, cfg);
            this.putStringCfg(formats, PROPERTITY_AXIS_DATETIMELABELFORMATS_YEAR, cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_AXIS_DATETIMELABELFORMATS, new JSONObject(cfg));
        }
    }

    private void createStackLabels(CompositeMap view, Map map) {
        CompositeMap formats = view.getChild(PROPERTITY_AXIS_STACKLABELS);
        HashMap cfg = new HashMap();
        if (formats != null) {
            this.putStringCfg(formats, "align", cfg);
            this.putStringCfg(formats, "textAlign", cfg);
            this.putStringCfg(formats, "verticalAlign", cfg);
            this.putBooleanCfg(formats, "enabled", cfg);
            this.putFunctionCfg(formats, "formatter", cfg);
            this.putStyleCfg(formats, "style", cfg);
            this.putFloatCfg(formats, "rotation", cfg);
            this.putIntCfg(formats, "x", cfg);
            this.putIntCfg(formats, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_AXIS_STACKLABELS, new JSONObject(cfg));
        }
    }

    private void creatPlotBands(CompositeMap view, Map map) {
        CompositeMap pbs = view.getChild(PROPERTITY_AXIS_PLOTBANDS);
        if (pbs != null) {
            List list = pbs.getChilds();
            JSONArray array = null;
            if (list != null) {
                array = new JSONArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    HashMap cfg = new HashMap();
                    CompositeMap pb = (CompositeMap)it.next();
                    this.putStringCfg(pb, "color", cfg);
                    this.putIntCfg(pb, PROPERTITY_AXIS_PLOTBANDS_FROM, cfg);
                    this.putStringCfg(pb, "id", cfg);
                    this.createPlotLabel(pb, cfg);
                    this.putIntCfg(pb, PROPERTITY_AXIS_PLOTBANDS_TO, cfg);
                    this.putIntCfg(pb, "zIndex", cfg);
                    this.putEvents(pb, cfg);
                    array.put(cfg);
                }
                if (array != null) {
                    map.put(PROPERTITY_AXIS_PLOTBANDS, array);
                }
            }
        }
    }

    private void creatPlotLines(CompositeMap view, Map map) {
        CompositeMap pls = view.getChild(PROPERTITY_AXIS_PLOTLINES);
        if (pls != null) {
            List list = pls.getChilds();
            JSONArray array = null;
            if (list != null) {
                array = new JSONArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    HashMap cfg = new HashMap();
                    CompositeMap pl = (CompositeMap)it.next();
                    this.putStringCfg(pl, "color", cfg);
                    this.putStringCfg(pl, "id", cfg);
                    this.putIntCfg(pl, PROPERTITY_AXIS_PLOTLINES_VALUE, cfg);
                    this.putIntCfg(pl, "width", cfg);
                    this.createPlotLabel(pl, cfg);
                    this.putIntCfg(pl, "zIndex", cfg);
                    this.putEvents(pl, cfg);
                    array.put(cfg);
                }
                if (array != null) {
                    map.put(PROPERTITY_AXIS_PLOTLINES, array);
                }
            }
        }
    }

    private void createPlotLabel(CompositeMap view, Map map) {
        CompositeMap label = view.getChild(PROPERTITY_AXIS_PLOT_LABEL);
        HashMap cfg = new HashMap();
        if (label != null) {
            this.putStringCfg(label, "align", cfg);
            this.putStringCfg(label, "text", cfg);
            this.putStringCfg(label, "verticalAlign", cfg);
            this.putIntCfg(label, "rotation", cfg);
            this.putStyleCfg(label, "style", cfg);
            this.putStringCfg(label, "textAlign", cfg);
            this.putIntCfg(label, "x", cfg);
            this.putIntCfg(label, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put("label", new JSONObject(cfg));
        }
    }

    private void createTitle(CompositeMap view, Map map) {
        CompositeMap title = view.getChild(PROPERTITY_AXIS_TITLE);
        HashMap cfg = new HashMap();
        if (title != null) {
            this.putStringCfg(title, "align", cfg);
            this.putIntCfg(title, "margin", cfg);
            this.putStyleCfg(title, "style", cfg);
            this.putIntCfg(title, "rotation", cfg);
            this.putStringCfg(title, "text", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put(PROPERTITY_AXIS_TITLE, new JSONObject(cfg));
        }
    }
}

