/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class AccordionMenu
extends Component {
    private static final String PROPERTY_DISPLAY_FIELD = "displayfield";
    private static final String PROPERTY_MIN_HEIGHT = "minheight";
    private static final String PROPERTY_PARENT_FIELD = "parentfield";
    private static final String PROPERTY_ID_FIELD = "idfield";
    private static final String PROPERTY_SEQUENCE_FIELD = "sequencefield";
    private static final String PROPERTY_ICON = "icon";
    private static final String PROPERTY_INFO = "information";
    private static final String MENU_ID = "menu_id";
    private static final String SUBMENU_ID = "submenu_id";
    public static final String CONFIG_CONTEXT = "context";

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "accordionmenu/AccordionMenu-min.css");
        this.addJavaScript(session, context, "accordionmenu/AccordionMenu-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        String subMenuID;
        CompositeMap params;
        String menuID;
        String minHeight;
        String info;
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        String displayField = view.getString(PROPERTY_DISPLAY_FIELD);
        String parentField = view.getString(PROPERTY_PARENT_FIELD);
        String idField = view.getString(PROPERTY_ID_FIELD);
        String sequence = view.getString(PROPERTY_SEQUENCE_FIELD);
        String icon = TextParser.parse(view.getString(PROPERTY_ICON), model);
        if (null == icon) {
            icon = "";
        }
        if (null != (info = TextParser.parse(view.getString(PROPERTY_INFO), model))) {
            map.put(PROPERTY_INFO, info);
        }
        if (null != (minHeight = view.getString(PROPERTY_MIN_HEIGHT)) && !minHeight.isEmpty()) {
            map.put(PROPERTY_MIN_HEIGHT, "min-height:" + minHeight + "px");
        }
        if ((menuID = (String)(params = model.getRoot()).getObject("/parameter/@menu_id")) == null) {
            menuID = "";
        }
        if ((subMenuID = (String)params.getObject("/parameter/@submenu_id")) == null) {
            subMenuID = "";
        }
        this.addConfig(MENU_ID, menuID);
        this.addConfig(SUBMENU_ID, subMenuID);
        this.addConfig(PROPERTY_PARENT_FIELD, parentField);
        this.addConfig(PROPERTY_ID_FIELD, idField);
        this.addConfig(PROPERTY_DISPLAY_FIELD, displayField);
        this.addConfig(PROPERTY_ICON, icon);
        this.addConfig(PROPERTY_SEQUENCE_FIELD, sequence);
        map.put("config", this.getConfigString());
    }
}

