/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.actions;

import aurora.database.FetchDescriptor;
import aurora.database.IResultSetConsumer;
import aurora.database.rsconsumer.CompositeMapCreator;
import aurora.database.rsconsumer.IRootMapAcceptable;
import aurora.database.service.ServiceOption;
import aurora.database.service.SqlServiceContext;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.composite.TextParser;
import uncertain.composite.transform.Transformer;
import uncertain.event.IContextAcceptable;
import uncertain.ocm.OCManager;
import uncertain.proc.AbstractDeferredEntry;
import uncertain.proc.ProcedureRunner;

public abstract class AbstractQueryAction
extends AbstractDeferredEntry {
    String mode = "freequery";
    String parameter;
    boolean fetchAll = false;
    boolean trace = false;
    boolean autoCount = false;
    Integer pageSize;
    String fieldNameCase = "lower";
    byte fieldNameCaseValue = (byte)2;
    boolean attribFromRequest = false;
    String rootPath;
    String recordName;
    List transform_list;
    String connectionName;
    IResultSetConsumer rsConsummer;

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    protected abstract void doQuery(CompositeMap var1, IResultSetConsumer var2, FetchDescriptor var3) throws Exception;

    protected abstract void prepare(CompositeMap var1) throws Exception;

    protected abstract void cleanUp(CompositeMap var1);

    public AbstractQueryAction(OCManager oc_manager) {
        super(oc_manager);
    }

    protected void transferServiceOption(ServiceOption option, String key) {
        option.getObjectContext().put(key, this.mEntryConfig.get(key));
    }

    protected CompositeMap getMapFromRootPath(CompositeMap context, String root_path) {
        if (root_path == null) {
            return context;
        }
        CompositeMap data = (CompositeMap)context.getObject(root_path);
        if (data == null) {
            data = context.createChildByTag(root_path);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(CompositeMap context_map) throws Exception {
        super.doPopulate();
        this.prepare(context_map);
        SqlServiceContext context = (SqlServiceContext)DynamicObject.cast(context_map, SqlServiceContext.class);
        ServiceOption option = ServiceOption.createInstance();
        option.setQueryMode(this.mode);
        option.setAutoCount(this.autoCount);
        option.setConnectionName(this.connectionName);
        option.setFieldCase(this.fieldNameCaseValue);
        option.setRecordName(this.recordName);
        this.transferServiceOption(option, "defaultwhereclause");
        this.transferServiceOption(option, "queryorderby");
        context.setServiceOption(option);
        IResultSetConsumer consumer = null;
        try {
            CompositeMap result;
            Object obj;
            CompositeMap param = context.getCurrentParameter();
            if (this.parameter != null && (obj = param.getObject(this.parameter)) != null) {
                if (!(obj instanceof CompositeMap)) {
                    throw new IllegalArgumentException("query parameter should be instance of CompositeMap, but actually got " + obj.getClass().getName());
                }
                param = (CompositeMap)obj;
            }
            FetchDescriptor desc = FetchDescriptor.createFromParameter(context.getParameter());
            desc.setFetchAll(this.fetchAll);
            if (this.pageSize != null) {
                desc.setPageSize(this.pageSize);
            }
            if (this.rsConsummer != null) {
                consumer = this.rsConsummer;
            } else {
                consumer = (IResultSetConsumer)context.getInstanceOfType(IResultSetConsumer.class);
                if (consumer == null) {
                    consumer = new CompositeMapCreator();
                    this.mOCManager.populateObject(this.mEntryConfig, consumer);
                }
            }
            if (consumer instanceof IContextAcceptable) {
                ((IContextAcceptable)((Object)consumer)).setContext(context_map);
            }
            if (consumer instanceof IRootMapAcceptable && (result = this.getMapFromRootPath(context.getModel(), TextParser.parse(this.rootPath, context.getObjectContext()))) != null) {
                ((IRootMapAcceptable)((Object)consumer)).setRoot(result);
            }
            context.setResultsetConsumer(consumer);
            this.doQuery(param, consumer, desc);
            if (this.transform_list != null && consumer instanceof IRootMapAcceptable) {
                CompositeMap root = ((IRootMapAcceptable)((Object)consumer)).getRoot();
                Transformer.doBatchTransform(root, this.transform_list);
            }
        }
        finally {
            context.setServiceOption(null);
            context.setResultsetConsumer(null);
            this.cleanUp(context_map);
        }
    }

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        this.query(runner.getContext());
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void addTransformList(CompositeMap tlist) {
        this.transform_list = tlist.getChilds();
    }

    public boolean getFetchAll() {
        return this.fetchAll;
    }

    public void setFetchAll(boolean fetchAll) {
        this.fetchAll = fetchAll;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean getAutoCount() {
        return this.autoCount;
    }

    public void setAutoCount(boolean autoCount) {
        this.autoCount = autoCount;
    }

    public String getFieldNameCase() {
        return this.fieldNameCase;
    }

    public void setFieldNameCase(String fieldNameCase) {
        this.fieldNameCase = fieldNameCase;
        if ("upper".equalsIgnoreCase(fieldNameCase)) {
            this.fieldNameCaseValue = 1;
        } else if ("lower".equalsIgnoreCase(fieldNameCase)) {
            this.fieldNameCaseValue = (byte)2;
        } else if ("unassigned".equalsIgnoreCase(fieldNameCase)) {
            this.fieldNameCaseValue = 0;
        }
    }

    protected byte getFieldNameCaseValue() {
        return this.fieldNameCaseValue;
    }

    public void addConsumer(CompositeMap processor) {
        CompositeMap child;
        Object inst;
        List childs = processor.getChilds();
        if (childs == null) {
            // empty if block
        }
        if (childs.size() != 1) {
            // empty if block
        }
        if ((inst = this.mOCManager.createObject(child = (CompositeMap)childs.get(0))) == null || !(inst instanceof IResultSetConsumer)) {
            // empty if block
        }
        this.rsConsummer = (IResultSetConsumer)inst;
    }

    public boolean getAttribFromRequest() {
        return this.attribFromRequest;
    }

    public void setAttribFromRequest(boolean attribFromRequest) {
        this.attribFromRequest = attribFromRequest;
    }
}

