/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.script.scriptobject;

import aurora.application.script.scriptobject.CompositeMap;
import aurora.application.script.scriptobject.ScriptUtil;
import aurora.database.FetchDescriptor;
import aurora.database.rsconsumer.CompositeMapCreator;
import aurora.database.service.BusinessModelService;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.ServiceOption;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import uncertain.composite.TextParser;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;

public class ModelServiceObject
extends ScriptableObject {
    private static final long serialVersionUID = 8195408589085036558L;
    public static final String CLASS_NAME = "ModelService";
    private BusinessModelService service;
    private uncertain.composite.CompositeMap context;
    private DatabaseServiceFactory svcFactory;
    private FetchDescriptor desc = FetchDescriptor.fetchAll();
    private BusinessModelServiceContext serviceContext;

    public ModelServiceObject() {
        this.context = ScriptUtil.getContext();
        IObjectRegistry registry = ScriptUtil.getObjectRegistry(this.context);
        if (registry != null) {
            UncertainEngine uEngine = (UncertainEngine)registry.getInstanceOfType(UncertainEngine.class);
            this.svcFactory = new DatabaseServiceFactory(uEngine);
        }
    }

    public ModelServiceObject(String model) {
        this();
        model = TextParser.parse(model, this.context);
        try {
            this.service = this.svcFactory.getModelService(model, this.context);
            this.serviceContext = this.service.getServiceContext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object jsGet_fetchDescriptor() {
        NativeObject no = (NativeObject)ScriptUtil.newObject((Scriptable)this, "Object");
        ScriptableObject.putProperty((Scriptable)no, (String)"offset", (Object)this.desc.getOffSet());
        ScriptableObject.putProperty((Scriptable)no, (String)"pagesize", (Object)this.desc.getPageSize());
        ScriptableObject.putProperty((Scriptable)no, (String)"fetchAll", (Object)this.desc.getFetchAll());
        return Context.javaToJS((Object)no, (Scriptable)this);
    }

    public void jsSet_fetchDescriptor(Object obj) {
        if (!(obj instanceof NativeObject)) {
            this.desc = FetchDescriptor.fetchAll();
            return;
        }
        FetchDescriptor fd = new FetchDescriptor();
        NativeObject no = (NativeObject)obj;
        Object o = no.get((Object)"offset");
        if (ScriptUtil.isValid(o)) {
            fd.setOffSet(((Double)o).intValue());
        }
        if (ScriptUtil.isValid(o = no.get((Object)"pagesize"))) {
            fd.setPageSize(((Double)o).intValue());
        }
        o = no.get((Object)"fetchAll");
        fd.setFetchAll(Boolean.TRUE.equals(o));
        this.desc = fd;
    }

    public static ModelServiceObject jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length == 0 || args[0] == Context.getUndefinedValue()) {
            return new ModelServiceObject();
        }
        if (args[0] instanceof String) {
            return new ModelServiceObject((String)args[0]);
        }
        return new ModelServiceObject();
    }

    private uncertain.composite.CompositeMap convert(Object obj) {
        if (obj instanceof CompositeMap) {
            return ((CompositeMap)((Object)obj)).getData();
        }
        if (obj instanceof uncertain.composite.CompositeMap) {
            return (uncertain.composite.CompositeMap)obj;
        }
        if (obj instanceof NativeObject) {
            uncertain.composite.CompositeMap map = new uncertain.composite.CompositeMap();
            NativeObject no = (NativeObject)obj;
            for (Object o : no.keySet()) {
                if (!(o instanceof String)) continue;
                map.put(o, no.get(o));
            }
            return map;
        }
        return new uncertain.composite.CompositeMap();
    }

    public void jsFunction_execute(Object parameter) {
        this.jsFunction_executeDml(parameter, "Execute");
    }

    public void jsFunction_insert(Object parameter) {
        this.jsFunction_executeDml(parameter, "Insert");
    }

    public void jsFunction_update(Object parameter) {
        this.jsFunction_executeDml(parameter, "Update");
    }

    public void jsFunction_delete(Object parameter) {
        this.jsFunction_executeDml(parameter, "Delete");
    }

    public CompositeMap jsFunction_queryAsMap(Object parameter) {
        if (!ScriptUtil.isValid(parameter)) {
            parameter = this.context.getChild("parameter");
        }
        try {
            uncertain.composite.CompositeMap data = this.service.queryAsMap(this.convert(parameter), this.desc);
            CompositeMap map = (CompositeMap)ScriptUtil.newObject((Scriptable)this, "CompositeMap");
            map.setData(data);
            CompositeMap compositeMap = map;
            return compositeMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.jsSet_option(null);
        }
    }

    public CompositeMap jsFunction_queryIntoMap(CompositeMap root, Object parameter) {
        if (!(root instanceof CompositeMap)) {
            throw new RuntimeException("invalid root");
        }
        if (!ScriptUtil.isValid(parameter)) {
            parameter = this.context.getChild("parameter");
        }
        try {
            this.service.queryIntoMap(this.convert(parameter), this.desc, root.getData());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.jsSet_option(null);
        }
        return root;
    }

    public void jsFunction_query() {
        try {
            ServiceOption so = (ServiceOption)this.context.get("__database_service_option");
            if (so != null) {
                String path = so.getString("rootPath");
                uncertain.composite.CompositeMap root = this.getMapFromRootPath(path);
                CompositeMapCreator cmc = new CompositeMapCreator(root);
                this.serviceContext.setResultsetConsumer(cmc);
            }
            this.service.query();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.jsSet_option(null);
        }
    }

    private uncertain.composite.CompositeMap getMapFromRootPath(String rootPath) {
        uncertain.composite.CompositeMap root;
        uncertain.composite.CompositeMap model = this.context.getChild("model");
        if (model == null) {
            model = this.context.createChild("model");
        }
        if ((root = (uncertain.composite.CompositeMap)model.getObject(rootPath)) == null) {
            root = model.createChildByTag(rootPath);
        }
        return root;
    }

    public void jsFunction_executeDml(Object parameter, String operation) {
        try {
            if (!ScriptUtil.isValid(parameter)) {
                parameter = this.context.getChild("parameter");
            }
            this.service.executeDml(this.convert(parameter), operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.jsSet_option(null);
        }
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public Object jsGet_option() {
        ServiceOption so = (ServiceOption)this.context.get("__database_service_option");
        if (so == null) {
            return null;
        }
        uncertain.composite.CompositeMap map = so.getObjectContext();
        NativeObject no = (NativeObject)ScriptUtil.newObject((Scriptable)this, "Object");
        for (Object o : map.keySet()) {
            if (!(o instanceof String)) continue;
            ScriptableObject.putProperty((Scriptable)no, (String)((String)o), map.get(o));
        }
        return no;
    }

    public void jsSet_option(Object obj) {
        if (!(obj instanceof NativeObject)) {
            this.context.put("__database_service_option", (Object)null);
            return;
        }
        NativeObject no = (NativeObject)obj;
        ServiceOption so = ServiceOption.createInstance();
        so.setFieldCase((byte)2);
        so.setQueryMode("freequery");
        for (Object o : no.keySet()) {
            if (!(o instanceof String)) continue;
            so.put(o, no.get(o));
            so.put(o.toString().toLowerCase(), no.get(o));
        }
        this.context.put("__database_service_option", so);
    }
}

