/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.application.action.ActionUtil;
import aurora.application.script.engine.ScriptRunner;
import javax.script.ScriptException;
import org.mozilla.javascript.JavaScriptException;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class ServerScript
extends AbstractEntry {
    String exp = null;
    String resultpath = null;
    String cdata = null;
    int lineno = -1;
    private IObjectRegistry registry;

    public ServerScript(OCManager oc_manager, IObjectRegistry registry) {
        this.registry = registry;
    }

    public String getResultpath() {
        return this.resultpath;
    }

    public void setResultpath(String resultpath) {
        this.resultpath = resultpath;
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) {
        this.exp = exp;
    }

    @Override
    public void run(ProcedureRunner runner) {
        CompositeMap context = runner.getContext();
        if (this.exp == null) {
            this.exp = this.cdata;
        }
        try {
            ScriptRunner sr = new ScriptRunner(this.exp, context, this.registry);
            Object res = sr.run();
            if (this.resultpath != null) {
                context.putObject(this.resultpath, res, true);
            }
        }
        catch (ScriptException e) {
            JavaScriptException jse;
            Object v;
            if (e.getCause() instanceof JavaScriptException && (v = (jse = (JavaScriptException)e.getCause()).getValue()) instanceof String) {
                ActionUtil.raiseApplicationError(runner, this.registry, v.toString());
                return;
            }
            StringBuilder sb = new StringBuilder(500);
            sb.append("ScriptException<br/>\n");
            sb.append("source:" + this.source + "<br/>\n");
            sb.append("line :" + (this.lineno + e.getLineNumber() - 1) + "<br/>\n");
            sb.append(e.getMessage() + "<br/>\n");
            throw new RuntimeException(sb.toString());
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void beginConfigure(CompositeMap config) {
        super.beginConfigure(config);
        this.lineno = config.getLocationNotNull().getStartLine();
        this.cdata = config.getText();
        if (this.cdata == null) {
            this.cdata = "";
        }
    }
}

