/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bill99;

import aurora.plugin.bill99.Bill99;
import aurora.plugin.bill99.Configuration;
import aurora.plugin.bill99.MD5Util;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class Send
extends AbstractEntry {
    private String merchantAcctId;
    private String key;
    private String inputCharset;
    private String pageUrl;
    private String bgUrl;
    private String version;
    private String language;
    private String signType;
    private String payerName;
    private String payerContactType;
    private String payerContact;
    private String orderId;
    private String orderAmount;
    private String orderTime;
    private String productName;
    private String productNum;
    private String productId;
    private String productDesc;
    private String ext1;
    private String ext2;
    private String payType;
    private String bankId;
    private String redoFlag;
    private String pid;
    private String payUrl;

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        HttpServletRequest request = serviceInstance.getRequest();
        request.setCharacterEncoding("GBK");
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
        CompositeMap model = service.getModel();
        this.initConfig();
        CompositeMap bill99 = model.createChild("bill99");
        this.pageUrl = this.getValue(context, this.getPageUrl());
        this.bgUrl = this.getValue(context, this.getBgUrl());
        this.payerName = this.getValue(context, this.getPayerName());
        this.payerContact = this.getValue(context, this.getPayerContact());
        this.orderId = this.getValue(context, this.getOrderId());
        this.orderAmount = this.getValue(context, this.getOrderAmount());
        this.productName = this.getValue(context, this.getProductName());
        this.productNum = this.getValue(context, this.getProductNum());
        this.ext2 = this.getValue(context, this.getExt2());
        this.ext1 = this.getValue(context, this.getExt1());
        this.productDesc = this.getValue(context, this.getProductDesc());
        this.productId = this.getValue(context, this.getProductId());
        this.orderTime = this.getValue(context, this.getOrderTime());
        bill99.put((Object)Bill99.inputCharset, (Object)this.inputCharset);
        bill99.put((Object)Bill99.pageUrl, (Object)this.pageUrl);
        bill99.put((Object)Bill99.bgUrl, (Object)this.bgUrl);
        bill99.put((Object)Bill99.version, (Object)this.version);
        bill99.put((Object)Bill99.language, (Object)this.language);
        bill99.put((Object)Bill99.signType, (Object)this.signType);
        bill99.put((Object)Bill99.merchantAcctId, (Object)this.merchantAcctId);
        bill99.put((Object)Bill99.payerName, (Object)this.payerName);
        bill99.put((Object)Bill99.payerContactType, (Object)this.payerContactType);
        bill99.put((Object)Bill99.payerContact, (Object)this.payerContact);
        bill99.put((Object)Bill99.orderId, (Object)this.orderId);
        bill99.put((Object)Bill99.orderAmount, (Object)this.orderAmount);
        bill99.put((Object)Bill99.orderTime, (Object)this.orderTime);
        bill99.put((Object)Bill99.productName, (Object)this.productName);
        bill99.put((Object)Bill99.productNum, (Object)this.productNum);
        bill99.put((Object)Bill99.productId, (Object)this.productId);
        bill99.put((Object)Bill99.productDesc, (Object)this.productDesc);
        bill99.put((Object)Bill99.ext1, (Object)this.ext1);
        bill99.put((Object)Bill99.ext2, (Object)this.ext2);
        bill99.put((Object)Bill99.payType, (Object)this.payType);
        bill99.put((Object)Bill99.bankId, (Object)this.bankId);
        bill99.put((Object)Bill99.redoFlag, (Object)this.redoFlag);
        bill99.put((Object)Bill99.pid, (Object)this.pid);
        bill99.put((Object)Bill99.key, (Object)this.key);
        bill99.put((Object)Bill99.payUrl, (Object)this.payUrl);
        String signMsg = this.createSignMSG();
        bill99.put((Object)Bill99.signMsg, (Object)signMsg);
    }

    private String getValue(CompositeMap context, String key) {
        if (key != null) {
            return TextParser.parse((String)key, (CompositeMap)context);
        }
        return "";
    }

    private String createSignMSG() throws UnsupportedEncodingException {
        String signMsgVal = "";
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.inputCharset, this.inputCharset);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.pageUrl, this.pageUrl);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.bgUrl, this.bgUrl);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.version, this.version);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.language, this.language);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.signType, this.signType);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.merchantAcctId, this.merchantAcctId);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.payerName, this.payerName);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.payerContactType, this.payerContactType);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.payerContact, this.payerContact);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.orderId, this.orderId);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.orderAmount, this.orderAmount);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.orderTime, this.orderTime);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.productName, this.productName);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.productNum, this.productNum);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.productId, this.productId);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.productDesc, this.productDesc);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.ext1, this.ext1);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.ext2, this.ext2);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.payType, this.payType);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.bankId, this.bankId);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.redoFlag, this.redoFlag);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.pid, this.pid);
        signMsgVal = Bill99.appendParam(signMsgVal, Bill99.key, this.key);
        String signMsg = MD5Util.md5Hex(signMsgVal.getBytes("gb2312")).toUpperCase();
        return signMsg;
    }

    public void initConfig() {
        this.merchantAcctId = this.getVaule(Bill99.merchantAcctId);
        this.key = this.getVaule(Bill99.key);
        this.inputCharset = this.getVaule(Bill99.inputCharset);
        this.version = this.getVaule(Bill99.version);
        this.language = this.getVaule(Bill99.language);
        this.signType = this.getVaule(Bill99.signType);
        this.payerContactType = this.getVaule(Bill99.payerContactType);
        this.payType = this.getVaule(Bill99.payType);
        this.bankId = this.getVaule(Bill99.bankId);
        this.redoFlag = this.getVaule(Bill99.redoFlag);
        this.pid = this.getVaule(Bill99.pid);
        this.payUrl = this.getVaule(Bill99.payUrl);
    }

    private String getVaule(String key) {
        String value = Configuration.getInstance().getValue(key);
        return value == null ? "" : value;
    }

    public String getMerchantAcctId() {
        return this.merchantAcctId;
    }

    public void setOrderTime(String orderTime) {
        this.orderTime = orderTime;
    }

    public String getKey() {
        return this.key;
    }

    public String getInputCharset() {
        return this.inputCharset;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getBgUrl() {
        return this.bgUrl;
    }

    public void setBgUrl(String bgUrl) {
        this.bgUrl = bgUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSignType() {
        return this.signType;
    }

    public String getPayerName() {
        return this.payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    public String getPayerContactType() {
        return this.payerContactType;
    }

    public String getPayerContact() {
        return this.payerContact;
    }

    public void setPayerContact(String payerContact) {
        this.payerContact = payerContact;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
    }

    public String getOrderTime() {
        return this.orderTime;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductNum() {
        return this.productNum;
    }

    public void setProductNum(String productNum) {
        this.productNum = productNum;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductDesc() {
        return this.productDesc;
    }

    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }

    public String getExt1() {
        return this.ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return this.ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getPayType() {
        return this.payType;
    }

    public String getBankId() {
        return this.bankId;
    }

    public String getRedoFlag() {
        return this.redoFlag;
    }

    public String getPid() {
        return this.pid;
    }
}

