/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util;

public class XMLWritter {
    public static String DEFAULT_ENCODING = "utf-8";

    public static String getXMLDecl(String encoding) {
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        return "<?xml version=\"1.0\" encoding = \"" + encoding + "\"?>\r\n";
    }

    public static String startTag(String element) {
        return "<" + element + ">";
    }

    public static String endTag(String element) {
        return "</" + element + ">";
    }

    public static String cdata(String value) {
        return "<![CDATA[" + value + "]]>";
    }

    public static String getAttrib(String key, String value) {
        return key + '=' + '\"' + XMLWritter.escape(value) + '\"';
    }

    public static String escape(String value) {
        StringBuffer dom = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '<') {
                dom.append("&lt;");
                continue;
            }
            if (ch == '>') {
                dom.append("&gt;");
                continue;
            }
            if (ch == '&') {
                dom.append("&amp;");
                continue;
            }
            if (ch == '\"') {
                dom.append("&quot;");
                continue;
            }
            if (ch == '\'') {
                dom.append("&apos;");
                continue;
            }
            dom.append(ch);
        }
        return dom.toString();
    }
}

