/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.validation;

import aurora.service.validation.IParameter;

public class Parameter
implements IParameter {
    public static final String DEFAULT_DATA_TYPE = "java.lang.String";
    String name;
    String inputPath;
    String outputPath;
    String dataType;
    boolean isRequired = false;
    boolean isInput = true;
    boolean isOutput = false;
    String databaseTypeName;
    String defaultValue;

    public static Parameter createInputParameter(String name, String datatype) {
        Parameter param = new Parameter();
        param.setInput(true);
        param.setName(name);
        param.setDataType(datatype);
        return param;
    }

    public static Parameter createOutputParameter(String name, String datatype) {
        Parameter param = new Parameter();
        param.setOutput(true);
        param.setInput(false);
        param.setName(name);
        param.setDataType(datatype);
        return param;
    }

    public Parameter() {
    }

    public Parameter(IParameter source) {
        this.name = source.getName();
        this.dataType = source.getDataType();
        this.inputPath = source.getInputPath();
        this.defaultValue = source.getDefaultValue() == null ? null : source.getDefaultValue().toString();
    }

    @Override
    public String getInputPath() {
        return this.inputPath;
    }

    public void setParameterPath(String path) {
        this.inputPath = path;
    }

    public String getDatabaseTypeName() {
        return this.databaseTypeName;
    }

    public void setDatabaseTypeName(String databaseTypeName) {
        this.databaseTypeName = databaseTypeName;
    }

    @Override
    public String getDataType() {
        return this.dataType == null ? DEFAULT_DATA_TYPE : this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public boolean getInput() {
        return this.isInput;
    }

    public void setInput(boolean isInput) {
        this.isInput = isInput;
    }

    public boolean getOutput() {
        return this.isOutput;
    }

    public void setOutput(boolean isOutput) {
        this.isOutput = isOutput;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean getRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.inputPath == null) {
            this.inputPath = '@' + name;
        }
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(this.dataType == null ? "[DataType undefined]" : this.dataType).append(' ');
        out.append(this.name).append(' ');
        out.append("from ").append(this.inputPath).append(' ');
        out.append("required:").append(this.isRequired).append(" input:").append(this.isInput).append(" output:").append(this.isOutput);
        return out.toString();
    }

    public String getOutputPath() {
        return this.outputPath == null ? this.inputPath : this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }
}

