/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.msg;

import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageListener;
import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.INoticerConsumer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.GeneralException;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;

public class DefaultNoticeConsumer
extends AbstractLocatableObject
implements INoticerConsumer {
    private IObjectRegistry registry;
    private String topic;
    private Map<String, List<IMessageListener>> messageListeners = new HashMap<String, List<IMessageListener>>();
    private ILogger logger;

    public DefaultNoticeConsumer(IObjectRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void init(IMessageStub stub) throws Exception {
        if (this.topic == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "topic");
        }
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.registry);
        this.logger.log(Level.CONFIG, "start Consumer for topic:" + this.topic + " successfull!");
    }

    @Override
    public void onMessage(IMessage msg) {
        String messageText = null;
        try {
            messageText = msg.getText();
        }
        catch (Exception e) {
            throw new GeneralException("aurora.msg.jmsexception_error", new Object[]{e.getMessage()}, e);
        }
        List<IMessageListener> listeners = this.messageListeners.get(messageText);
        if (listeners != null) {
            for (IMessageListener l : listeners) {
                try {
                    l.onMessage(msg);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Listener:" + l.toString() + " occur exception.", e);
                    throw new RuntimeException("Listener:" + l.toString() + " occur exception.", e);
                }
            }
        }
    }

    @Override
    public void onShutdown() {
        this.messageListeners.clear();
    }

    @Override
    public void addListener(String message, IMessageListener listener) {
        List<IMessageListener> listeners = this.messageListeners.get(message);
        if (listeners == null) {
            listeners = new LinkedList<IMessageListener>();
            this.messageListeners.put(message, listeners);
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    @Override
    public void removeListener(String message, IMessageListener listener) {
        List<IMessageListener> listeners = this.messageListeners.get(message);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }
}

