/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sync.cvs;

import aurora.plugin.quartz.SchedulerConfig;
import aurora.plugin.sync.cvs.CVSClient;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.CVSAdapter;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class CVSLogSync
extends CVSAdapter {
    String syncModule;
    String jobName;
    String connectionString;
    String repositoryPath;
    boolean debug = false;
    boolean is_success = true;
    IObjectRegistry registry;
    ILogger mLogger;
    Connection conn;
    Map<String, String> dataMap = new HashMap<String, String>();
    final String getSyncInfoSql = "sys_cvs_sync_pkg.get_cvs_sync_info(?,?,?,?)";
    final String saveSql = "sys_cvs_sync_pkg.save_sync_log(?,?,?,?,?)";

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public CVSLogSync() {
        this.registry = SchedulerConfig.getObjectRegistry();
        this.mLogger = LoggingContext.getLogger((String)"aurora.plugin.cvs.sync", (IObjectRegistry)this.registry);
    }

    public void syncLog(Connection conn) throws SQLException, CommandAbortedException, AuthenticationException, IOException, CommandException {
        this.conn = conn;
        this.setSyncInfo();
        this.executeRlogCommand();
        if (!this.is_success) {
            throw new RuntimeException("CVSLogSync");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSyncInfo() throws SQLException {
        CallableStatement cstm = null;
        try {
            cstm = this.conn.prepareCall("{call sys_cvs_sync_pkg.get_cvs_sync_info(?,?,?,?)}");
            cstm.setString(1, this.jobName);
            cstm.registerOutParameter(2, 12);
            cstm.registerOutParameter(3, 12);
            cstm.registerOutParameter(4, 12);
            cstm.execute();
            this.syncModule = cstm.getString(2);
            this.connectionString = cstm.getString(3);
            this.repositoryPath = cstm.getString(4);
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeRlogCommand() throws CommandAbortedException, AuthenticationException, IOException, CommandException {
        CVSClient cvsclient = new CVSClient(this.connectionString);
        cvsclient.addCVSListener((CVSListener)this);
        try {
            RlogCommand command = new RlogCommand();
            command.setModule(this.syncModule);
            command.setCVSCommand('N', null);
            command.setCVSCommand('h', null);
            cvsclient.excute((Command)command);
        }
        finally {
            if (cvsclient != null) {
                cvsclient.closeConnection();
            }
        }
    }

    void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void messageSent(MessageEvent event) {
        this.is_success = !event.isError();
        String line = event.getMessage().trim();
        PrintStream stream = event.isError() ? System.err : System.out;
        StringBuffer taggedLine = new StringBuffer();
        if (event.isTagged()) {
            String message = MessageEvent.parseTaggedMessage((StringBuffer)taggedLine, (String)"Daniel Six");
            if (message != null) {
                stream.println(message);
            }
        } else {
            if (this.debug) {
                stream.println(line);
            }
            if (!"".equals(line.trim()) && !"No records selected.".equals(line)) {
                this.dataConvert(line);
            }
            if (line.startsWith("=======")) {
                try {
                    this.processSyncLog();
                    this.dataMap = new HashMap<String, String>();
                }
                catch (SQLException e) {
                    this.is_success = false;
                    this.mLogger.log(Level.SEVERE, null, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSyncLog() throws SQLException {
        CallableStatement cstm = null;
        try {
            cstm = this.conn.prepareCall("{call sys_cvs_sync_pkg.save_sync_log(?,?,?,?,?)}");
            cstm.setString(1, this.jobName);
            cstm.setString(2, this.dataMap.get("fileName"));
            cstm.setString(3, this.dataMap.get("head"));
            cstm.setString(4, this.dataMap.get("locks"));
            cstm.setString(5, this.dataMap.get("totalRevisions"));
            cstm.execute();
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
        }
    }

    void dataConvert(String line) {
        if (line.startsWith("RCS file")) {
            String[] array = line.split(":");
            String fileName = array[1];
            fileName = fileName.substring(this.repositoryPath.length() + 2);
            fileName = fileName.substring(0, fileName.lastIndexOf(","));
            this.dataMap.put("fileName", fileName.trim());
            return;
        }
        if (line.startsWith("head")) {
            this.dataMap.put("head", line.split(":").length > 1 ? line.split(":")[1].trim() : "");
            return;
        }
        if (line.startsWith("branch")) {
            this.dataMap.put("branch", line.split(":").length > 1 ? line.split(":")[1].trim() : "");
            return;
        }
        if (line.startsWith("locks")) {
            this.dataMap.put("locks", line.split(":").length > 1 ? line.split(":")[1].trim() : "");
            return;
        }
        if (line.startsWith("total revisions")) {
            this.dataMap.put("totalRevisions", line.split(":").length > 1 ? line.split(":")[1].trim() : "");
            return;
        }
    }
}

