/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.jms;

import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageDispatcher;
import aurora.application.features.msg.IMessageStub;
import aurora.plugin.jms.JMSUtil;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class MessageDispatcher
extends AbstractLocatableObject
implements IMessageDispatcher {
    private IObjectRegistry mRegistry;

    public MessageDispatcher(IObjectRegistry registry) {
        this.mRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String topic, IMessage message, CompositeMap context) throws Exception {
        if (topic == null) {
            BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"topic");
        }
        ILogger logger = LoggingContext.getLogger((CompositeMap)context, (String)"aurora.plugin.jms");
        IMessageStub messageStub = (IMessageStub)this.mRegistry.getInstanceOfType(IMessageStub.class);
        if (messageStub == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IMessageStub.class, (String)((Object)((Object)this)).getClass().getCanonicalName());
        }
        if (!messageStub.isStarted()) {
            throw new IllegalStateException("MessageStub is not started, please check the configuration.");
        }
        ConnectionFactory connectionFactory = (ConnectionFactory)this.mRegistry.getInstanceOfType(ConnectionFactory.class);
        if (connectionFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, ConnectionFactory.class);
        }
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            logger.log(Level.CONFIG, "create createTopic {0}", new Object[]{topic});
            Topic jmsTopic = session.createTopic(topic);
            messageProducer = session.createProducer((Destination)jmsTopic);
            logger.log(Level.CONFIG, "start producer connection");
            connection.start();
            logger.log(Level.CONFIG, "start producer successfull!");
            String parsedText = TextParser.parse((String)message.getText(), (CompositeMap)context);
            TextMessage textMessage = session.createTextMessage(parsedText);
            CompositeMap properties = message.getProperties();
            if (properties != null && !properties.isEmpty()) {
                Set set = properties.entrySet();
                for (Map.Entry en : set) {
                    textMessage.setObjectProperty(en.getKey().toString(), (Object)TextParser.parse((String)en.getValue().toString(), (CompositeMap)context));
                }
            }
            messageProducer.send((Message)textMessage);
            logger.log(Level.CONFIG, "Message:{0} sent", new Object[]{parsedText});
        }
        catch (Throwable throwable) {
            JMSUtil.freeMessageProducer(messageProducer);
            JMSUtil.freeJMSSession(session);
            JMSUtil.freeJMSConnection(connection);
            throw throwable;
        }
        JMSUtil.freeMessageProducer(messageProducer);
        JMSUtil.freeJMSSession(session);
        JMSUtil.freeJMSConnection(connection);
    }
}

