/*
 * Decompiled with CFR 0.152.
 */
package uncertain.datatype;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import uncertain.datatype.AbstractDataType;
import uncertain.datatype.ConvertionException;
import uncertain.datatype.DataType;

public class LongType
extends AbstractDataType
implements DataType {
    @Override
    public Class getJavaType() {
        return Long.class;
    }

    @Override
    public int getSqlType() {
        return -5;
    }

    @Override
    public Object getObject(CallableStatement stmt, int id) throws SQLException {
        try {
            return this.convert(stmt.getObject(id));
        }
        catch (ConvertionException ex) {
            throw new SQLException("Error when converting data from Statement to long for field No." + id);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int id) throws SQLException {
        try {
            return this.convert(rs.getObject(id));
        }
        catch (ConvertionException ex) {
            throw new SQLException("Error when converting data from ResultSet to long for field No." + id);
        }
    }

    @Override
    public void registerParameter(CallableStatement stmt, int id) throws SQLException {
        stmt.registerOutParameter(id, -5);
    }

    @Override
    public void setParameter(PreparedStatement stmt, int id, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(id, this.getSqlType());
        } else {
            stmt.setLong(id, ((Number)value).longValue());
        }
    }

    @Override
    public Object convert(Object value) throws ConvertionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof String) {
            if (((String)value).length() == 0) {
                return null;
            }
            try {
                return new Long((String)value);
            }
            catch (NumberFormatException ex) {
                throw new ConvertionException("Can't convert from string to long", ex);
            }
        }
        if (value instanceof Number) {
            return new Long(((Number)value).longValue());
        }
        return null;
    }
}

