/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite.transform;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.composite.transform.AbstractTransform;
import uncertain.composite.transform.GroupConfig;
import uncertain.composite.transform.GroupTransformer;
import uncertain.composite.transform.Transformer;
import uncertain.proc.ProcedureRunner;

public class GroupTransform
extends AbstractTransform {
    public static final String KEY_GROUP_NAME = "groupName";
    public static final String KEY_SUB_GROUP_NAME = "subGroupName";
    public static final String KEY_GROUP_FIELD_NAME = "name";
    public static final String KEY_REMOVE_FIELD = "removeField";
    public static final String KEY_GROUP_FIELD = "groupField";
    final String KEY_GROUP_CONFIG = "groupConfig";
    final String KEY_SOURCE = "source";
    final String KEY_TARGET = "target";
    CompositeMap elementConifg;

    public static CompositeMap createGroupTransform(String group_field, String group_name) {
        CompositeMap config = Transformer.createTransformConfig(GroupTransformer.class.getName());
        config.setName("transform");
        config.put(KEY_GROUP_NAME, group_name);
        config.put(KEY_GROUP_FIELD, group_field);
        return config;
    }

    public static CompositeMap addGroupField(CompositeMap config, String field_name, boolean remove) {
        CompositeMap field = config.createChild(KEY_GROUP_FIELD);
        field.put(KEY_GROUP_FIELD_NAME, field_name);
        field.putBoolean(KEY_REMOVE_FIELD, remove);
        return field;
    }

    public CompositeMap transform(CompositeMap source, CompositeMap transform_config) {
        if (source == null || transform_config == null) {
            return null;
        }
        boolean has_group_fields = transform_config.getChilds() != null;
        String group_field = transform_config.getString(KEY_GROUP_FIELD);
        if (group_field == null) {
            return source;
        }
        String sub_group_name = transform_config.getString(KEY_SUB_GROUP_NAME);
        Iterator childs = source.getChildIterator();
        if (childs == null) {
            return source;
        }
        String group_name = transform_config.getString(KEY_GROUP_NAME, "group");
        LinkedHashMap groups = new LinkedHashMap();
        while (childs.hasNext()) {
            CompositeMap item = (CompositeMap)childs.next();
            Object value = item.get(group_field);
            CompositeMap group_item = (CompositeMap)groups.get(value);
            if (group_item == null) {
                group_item = new CompositeMap(group_name);
                if (has_group_fields) {
                    Iterator gfields = transform_config.getChildIterator();
                    while (gfields.hasNext()) {
                        CompositeMap gf = (CompositeMap)gfields.next();
                        Object gf_name = gf.get(KEY_GROUP_FIELD_NAME);
                        group_item.put(gf_name, item.get(gf_name));
                    }
                }
                groups.put(value, group_item);
            }
            if (sub_group_name != null) {
                CompositeMap sub_group = group_item.getChild(sub_group_name);
                if (sub_group == null) {
                    sub_group = group_item.createChild(sub_group_name);
                }
                sub_group.addChild(item);
                continue;
            }
            group_item.addChild(item);
        }
        source.getChilds().clear();
        source.addChilds(groups.values());
        return source;
    }

    public static CompositeMap transform(CompositeMap source, GroupConfig config) {
        if (source == null || config == null) {
            return source;
        }
        Iterator childs = source.getChildIterator();
        if (childs == null) {
            return source;
        }
        LinkedHashMap<String, CompositeMap> groups = new LinkedHashMap<String, CompositeMap>();
        while (childs.hasNext()) {
            CompositeMap child = (CompositeMap)childs.next();
            StringBuffer key = new StringBuffer("<");
            String[] groupFields = config.getGroupKeyFields();
            for (int i = 0; i < groupFields.length; ++i) {
                key.append(" ").append(groupFields[i]).append("=\"").append(child.getString(groupFields[i]) + "\"");
            }
            key.append(">");
            CompositeMap group_item = (CompositeMap)groups.get(key.toString());
            if (group_item == null) {
                if (config.isExtendParentAttributes()) {
                    group_item = (CompositeMap)source.clone();
                    group_item.getChilds().clear();
                    group_item.setName(config.getRecordName());
                } else {
                    group_item = new CompositeMap(config.getRecordName());
                }
                for (int i = 0; i < groupFields.length; ++i) {
                    group_item.put(groupFields[i], child.get(groupFields[i]));
                }
                String[] attributes = config.getGroupAttributes();
                if (attributes != null) {
                    for (int i = 0; i < attributes.length; ++i) {
                        group_item.put(attributes[i], child.get(attributes[i]));
                    }
                }
                groups.put(key.toString(), group_item);
            }
            group_item.addChild(child);
        }
        source.getChilds().clear();
        source.addChilds(groups.values());
        return source;
    }

    public static CompositeMap transform(CompositeMap source, GroupConfig config, int childLevel) {
        LinkedList result = new LinkedList();
        CompositeUtil.getLevelChilds(source, childLevel, result);
        if (result == null || result.isEmpty()) {
            return null;
        }
        Iterator it = result.iterator();
        while (it.hasNext()) {
            GroupTransform.transform((CompositeMap)it.next(), config);
        }
        return source;
    }

    public static CompositeMap transform(CompositeMap source, GroupConfig[] configs) {
        if (source == null || configs == null) {
            return source;
        }
        for (int i = 0; i < configs.length; ++i) {
            GroupTransform.transform(source, configs[i], i);
        }
        return source;
    }

    public static CompositeMap transformByConfig(CompositeMap source, CompositeMap config) {
        if (source == null || config == null) {
            return source;
        }
        GroupConfig[] configs = GroupConfig.createGroupConfigs(config);
        return GroupTransform.transform(source, configs);
    }

    public static void main(String[] args) {
        CompositeMap root = new CompositeMap("root");
        for (int i = 0; i < 10; ++i) {
            CompositeMap record = new CompositeMap("recrod");
            record.put(KEY_GROUP_FIELD_NAME, "name_" + Math.round(Math.random() * 10.0));
            record.put("a", "a_" + Math.round(Math.random() * 10.0));
            record.put("b", "b_" + Math.round(Math.random() * 10.0));
            root.addChild(record);
        }
        System.out.println(root.toXML());
        CompositeMap copyRoot = (CompositeMap)root.clone();
        CompositeMap source = GroupTransform.transform(root, new GroupConfig(new String[]{KEY_GROUP_FIELD_NAME}));
        System.out.println(source.toXML());
        CompositeMap test = new CompositeMap();
        CompositeMap record1 = new CompositeMap();
        record1.put("group_key_fields", "name,a");
        record1.put("record_name", "level");
        test.addChild(record1);
        CompositeMap record2 = new CompositeMap();
        record2.put("group_key_fields", "b");
        record2.put("record_name", "test");
        test.addChild(record2);
        CompositeMap copy2 = GroupTransform.transformByConfig(copyRoot, test);
        System.out.println(copy2.toXML());
    }

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        String source = this.elementConifg.getString(this.KEY_SOURCE);
        assert (source != null);
        String target = this.elementConifg.getString(this.KEY_TARGET);
        assert (target != null);
        String groupConfig = this.elementConifg.getString(this.KEY_GROUP_CONFIG);
        CompositeMap context = runner.getContext();
        CompositeMap sourceMap = (CompositeMap)context.getObject(source);
        if (groupConfig != null) {
            CompositeMap groupConfigMap = (CompositeMap)context.getObject(groupConfig);
            context.putObject(target, GroupTransform.transformByConfig(sourceMap, groupConfigMap));
        } else {
            CompositeMap targetMap = (CompositeMap)sourceMap.clone();
            context.putObject(target, (Object)targetMap, true);
            this.transform(targetMap, this.elementConifg);
        }
    }

    @Override
    public void beginConfigure(CompositeMap config) {
        this.elementConifg = config;
    }
}

