/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

public final class BytesHelper {
    private BytesHelper() {
    }

    public static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    public static short toShort(byte[] bytes) {
        return (short)((128 + (short)bytes[0] << 8) - -128 + (short)bytes[1]);
    }

    public static byte[] toBytes(int value) {
        byte[] result = new byte[4];
        for (int i = 3; i >= 0; --i) {
            result[i] = (byte)((0xFFL & (long)value) + -128L);
            value >>>= 8;
        }
        return result;
    }

    public static byte[] toBytes(short value) {
        byte[] result = new byte[2];
        for (int i = 1; i >= 0; --i) {
            result[i] = (byte)((0xFFL & (long)value) + -128L);
            value = (short)(value >>> 8);
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println("0==" + BytesHelper.toInt(BytesHelper.toBytes(0)));
        System.out.println("1==" + BytesHelper.toInt(BytesHelper.toBytes(1)));
        System.out.println("-1==" + BytesHelper.toInt(BytesHelper.toBytes(-1)));
        System.out.println("-2147483648==" + BytesHelper.toInt(BytesHelper.toBytes(Integer.MIN_VALUE)));
        System.out.println("2147483647==" + BytesHelper.toInt(BytesHelper.toBytes(Integer.MAX_VALUE)));
        System.out.println("-1073741824==" + BytesHelper.toInt(BytesHelper.toBytes(-1073741824)));
        System.out.println("1073741823==" + BytesHelper.toInt(BytesHelper.toBytes(0x3FFFFFFF)));
    }
}

