/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component;

import aurora.application.ApplicationConfig;
import aurora.application.ApplicationViewConfig;
import aurora.application.IApplicationConfig;
import aurora.application.config.ScreenConfig;
import aurora.application.features.CachedScreenListener;
import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.service.ServiceInstance;
import aurora.service.controller.ControllerProcedures;
import aurora.service.http.AbstractFacadeServlet;
import aurora.service.http.HttpServiceFactory;
import aurora.service.http.HttpServiceInstance;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.ISingleton;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class ScreenInclude
implements IViewBuilder,
ISingleton {
    public static final String KEY_SCREEN = "screen";
    public static final String DEFAULT_INCLUDED_SCREEN_TEMPLATE = "defaultincludedscreentemplate";
    IObjectRegistry mObjectRegistry;
    HttpServiceFactory mServiceFactory;
    IProcedureManager mProcedureManager;
    ApplicationConfig mApplicationConfig;
    CachedScreenListener mCacheListener;
    String mDefaultPackage = "aurora.ui.std";
    String mDefaultIncludedScreenTemplate = "defaultIncludedScreen";

    public static CompositeMap createScreenIncludeConfig(String screen_name) {
        CompositeMap config = new CompositeMap("a", "http://www.aurora-framework.org/application", "screen-include");
        config.put(KEY_SCREEN, screen_name);
        return config;
    }

    public ScreenInclude(IObjectRegistry reg) {
        this.mObjectRegistry = reg;
        HttpServiceFactory fact = (HttpServiceFactory)reg.getInstanceOfType(HttpServiceFactory.class);
        IProcedureManager pm = (IProcedureManager)reg.getInstanceOfType(IProcedureManager.class);
        IApplicationConfig config = (IApplicationConfig)reg.getInstanceOfType(IApplicationConfig.class);
        this.mCacheListener = (CachedScreenListener)reg.getInstanceOfType(CachedScreenListener.class);
        this.init(fact, pm, config);
    }

    private void init(HttpServiceFactory fact, IProcedureManager pm, IApplicationConfig config) {
        ApplicationViewConfig view_config;
        this.mServiceFactory = fact;
        this.mProcedureManager = pm;
        this.mApplicationConfig = (ApplicationConfig)config;
        if (this.mApplicationConfig != null && (view_config = this.mApplicationConfig.getApplicationViewConfig()) != null) {
            this.mDefaultPackage = view_config.getDefaultPackage();
            this.mDefaultIncludedScreenTemplate = view_config.getString(DEFAULT_INCLUDED_SCREEN_TEMPLATE);
            if (this.mDefaultIncludedScreenTemplate == null) {
                this.mDefaultIncludedScreenTemplate = "defaultIncludedScreen";
            }
        }
    }

    public HttpServiceInstance createSubInstance(String name, CompositeMap context) throws SAXException, IOException {
        HttpServiceInstance parent = (HttpServiceInstance)ServiceInstance.getInstance(context);
        HttpServiceInstance svc = this.mServiceFactory.createHttpService(name, parent);
        CompositeMap config = this.mServiceFactory.loadServiceConfig(name);
        ScreenConfig scc = ScreenConfig.createScreenConfig(config);
        CompositeMap view_config = scc.getViewConfig();
        view_config.put("template", this.mDefaultIncludedScreenTemplate);
        view_config.put("package", this.mDefaultPackage);
        svc.setServiceConfigData(config);
        svc.getController().setProcedureName(ControllerProcedures.RUN_INCLUDED_SCREEN);
        return svc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScreenInclude(BuildSession session, CompositeMap model, CompositeMap view, CompositeMap root) throws Exception {
        String screen_name = view.getString(KEY_SCREEN);
        if (screen_name == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(view.asLocatable(), KEY_SCREEN);
        }
        int parameterpositiion = (screen_name = session.parseString(screen_name, model)).lastIndexOf("?");
        if (parameterpositiion != -1) {
            String parameter = screen_name.substring(parameterpositiion + 1, screen_name.length());
            screen_name = screen_name.substring(0, parameterpositiion);
            String[] parameters = parameter.split("&");
            CompositeMap pcm = root.getChild("parameter");
            for (int i = 0; i < parameters.length; ++i) {
                String p = parameters[i];
                String key = p.substring(0, p.indexOf("="));
                key = session.parseString(key, model);
                String value = p.substring(p.indexOf("=") + 1, p.length());
                value = session.parseString(value, model);
                pcm.put(key, value);
            }
        }
        ServiceInstance old_inst = ServiceInstance.getInstance(root);
        try {
            CachedScreenListener.CacheResult result;
            HttpServiceInstance sub_instance = this.createSubInstance(screen_name, root);
            ScreenConfig sub_config = ScreenConfig.createScreenConfig(sub_instance.getServiceConfigData());
            if (sub_config.isCacheEnabled() && this.mCacheListener != null && (result = this.mCacheListener.getCachedContent(sub_instance)).isHit()) {
                Writer out = session.getWriter();
                out.write(result.getContent().toString());
                out.flush();
                return;
            }
            ServiceInstance.setInstance(root, sub_instance);
            Procedure proc = AbstractFacadeServlet.getProcedureToRun(this.mProcedureManager, sub_instance);
            if (proc != null) {
                sub_instance.invoke(proc);
            }
        }
        finally {
            ServiceInstance.setInstance(root, old_inst);
        }
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        CompositeMap view = view_context.getView();
        CompositeMap model = view_context.getModel();
        try {
            this.doScreenInclude(session, model, view_context.getView(), model.getRoot());
        }
        catch (Exception ex) {
            throw new ViewCreationException("aurora.presentation.component.screen_include_invoke_error", new Object[]{view.toXML()}, (Throwable)ex, view);
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

