/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.features;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.database.IResultSetConsumer;
import aurora.database.features.ICacheBasedMultiLanguageProvider;
import aurora.database.profile.IDatabaseFactory;
import aurora.service.ServiceThreadLocal;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.ConfigurationError;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;

public class CacheBasedMultiLanguageDisplay {
    private ICacheBasedMultiLanguageProvider cacheProvider;
    private CompositeMap dbProperties;
    protected boolean hasMlFields = false;

    public CacheBasedMultiLanguageDisplay(IObjectRegistry objectRegistry, IDatabaseFactory databaseFactory) throws IOException {
        this.cacheProvider = (ICacheBasedMultiLanguageProvider)objectRegistry.getInstanceOfType(ICacheBasedMultiLanguageProvider.class);
        if (this.cacheProvider == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, ICacheBasedMultiLanguageProvider.class, CacheBasedMultiLanguageDisplay.class.getCanonicalName());
        }
        this.dbProperties = databaseFactory.getProperties();
        if (this.dbProperties == null) {
            throw new ConfigurationError("Database Properties undifined");
        }
    }

    public void onPrepareBusinessModel(BusinessModel model) {
        Field[] fields = model.getFields();
        Field field = null;
        Field refield = null;
        String multiLanguageDescField = null;
        int l = fields.length;
        block0: for (int i = 0; i < l; ++i) {
            field = fields[i];
            if (field.isReferenceField()) {
                CompositeMap cmap = (CompositeMap)field.getReferredField().getObjectContext().clone();
                cmap.copy(field.getObjectContext());
                refield = Field.getInstance(cmap);
            } else {
                refield = field;
            }
            if (!refield.getMultiLanguage()) continue;
            this.hasMlFields = true;
            multiLanguageDescField = refield.getMultiLanguageDescField();
            for (int j = 0; j < l; ++j) {
                Field f = fields[j];
                if (!f.getName().equalsIgnoreCase(multiLanguageDescField) || f.isExpression()) continue;
                f.setForQuery(false);
                f.setForSelect(false);
                continue block0;
            }
        }
        model.makeReady();
    }

    public void postFetchResultSet(BusinessModel model, IResultSetConsumer consumer) throws SQLException {
        if (consumer == null) {
            return;
        }
        Object result = consumer.getResult();
        if (!(result instanceof CompositeMap)) {
            return;
        }
        Field[] fields = model.getFields();
        Field field2 = null;
        Field refield = null;
        String idFieldName = null;
        String multiLanguageDescField = null;
        String language = TextParser.parse("${" + this.dbProperties.getString("language_path") + "}", ServiceThreadLocal.getCurrentThreadContext());
        for (Field field2 : fields) {
            idFieldName = field2.getName();
            if (field2.isReferenceField()) {
                CompositeMap cmap = (CompositeMap)field2.getReferredField().getObjectContext().clone();
                cmap.copy(field2.getObjectContext());
                refield = Field.getInstance(cmap);
            } else {
                refield = field2;
            }
            if (!refield.getMultiLanguage()) continue;
            multiLanguageDescField = refield.getMultiLanguageDescField();
            this.addDescription((CompositeMap)result, multiLanguageDescField, idFieldName, language, field2.getExpression());
        }
    }

    private void addDescription(CompositeMap data, String descriptionFieldName, String desp_id_column, String language, String expression) {
        if (data == null) {
            return;
        }
        if (data.getChilds() == null) {
            this.addRecordDescription(data, descriptionFieldName, desp_id_column, language);
            return;
        }
        Iterator it = data.getChildIterator();
        while (it.hasNext()) {
            CompositeMap record = (CompositeMap)it.next();
            this.addRecordDescription(record, descriptionFieldName, desp_id_column, language);
        }
    }

    private void addRecordDescription(CompositeMap data, String descriptionFieldName, String desp_id_column, String language) {
        Integer description_id = data.getInt(desp_id_column);
        if (description_id == null) {
            return;
        }
        data.put(descriptionFieldName, this.cacheProvider.getDescription(String.valueOf(description_id), language));
    }
}

