/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.script.engine;

import aurora.application.script.ScriptEngine;
import aurora.application.script.ScriptException;
import aurora.application.script.engine.RhinoScriptEngine;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class ScriptRunner {
    private String exp;
    private ScriptEngine engine;
    private CompositeMap context = null;

    public ScriptRunner(String script) {
        this.exp = script;
    }

    public ScriptRunner(String script, CompositeMap context) {
        this.exp = script;
        this.context = context;
    }

    public String getOriginalScript() {
        return this.exp;
    }

    public String getParsedScript() {
        if (this.context == null) {
            return this.exp;
        }
        return TextParser.parse(this.exp, this.context);
    }

    public Object run() throws ScriptException {
        if (this.engine == null) {
            this.engine = new RhinoScriptEngine();
        }
        String str = this.getParsedScript();
        return this.engine.eval(str);
    }

    public static void main(String[] args) throws ScriptException {
        ScriptRunner exp = new ScriptRunner("var t='f';t");
        System.out.println(exp.run());
    }
}

