/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.script.engine;

import aurora.application.script.AbstractScriptEngine;
import aurora.application.script.Bindings;
import aurora.application.script.Compilable;
import aurora.application.script.CompiledScript;
import aurora.application.script.Invocable;
import aurora.application.script.ScriptContext;
import aurora.application.script.ScriptEngineFactory;
import aurora.application.script.ScriptException;
import aurora.application.script.SimpleBindings;
import aurora.application.script.engine.ExternalScriptable;
import aurora.application.script.engine.InterfaceImplementor;
import aurora.application.script.engine.RhinoClassShutter;
import aurora.application.script.engine.RhinoCompiledScript;
import aurora.application.script.engine.RhinoScriptEngineFactory;
import aurora.application.script.engine.RhinoTopLevel;
import aurora.application.script.engine.RhinoWrapFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import sun.security.action.GetPropertyAction;

public final class RhinoScriptEngine
extends AbstractScriptEngine
implements Invocable,
Compilable {
    private static final boolean DEBUG = false;
    private RhinoTopLevel topLevel;
    private Map<Object, Object> indexedProps;
    private ScriptEngineFactory factory;
    private InterfaceImplementor implementor;
    private static final int languageVersion = RhinoScriptEngine.getLanguageVersion();
    private static final int optimizationLevel = RhinoScriptEngine.getOptimizationLevel();
    private static final String RHINO_JS_VERSION = "rhino.js.version";
    private static final String RHINO_OPT_LEVEL = "rhino.opt.level";
    private static final String printSource = "function print(str, newline) {                \n    if (typeof(str) == 'undefined') {         \n        str = 'undefined';                    \n    } else if (str == null) {                 \n        str = 'null';                         \n    }                                         \n    var out = context.getWriter();            \n    if (!(out instanceof java.io.PrintWriter))\n        out = new java.io.PrintWriter(out);   \n    out.print(String(str));                   \n    if (newline) out.print('\\n');            \n    out.flush();                              \n}\nfunction println(str) {                       \n    print(str, true);                         \n}";

    private static int getLanguageVersion() {
        String tmp = AccessController.doPrivileged(new GetPropertyAction(RHINO_JS_VERSION));
        int version = tmp != null ? Integer.parseInt(tmp) : 180;
        return version;
    }

    private static int getOptimizationLevel() {
        int optLevel = -1;
        if (System.getSecurityManager() == null) {
            optLevel = Integer.getInteger(RHINO_OPT_LEVEL, -1);
        }
        return optLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhinoScriptEngine() {
        Context cx = RhinoScriptEngine.enterContext();
        try {
            this.topLevel = new RhinoTopLevel(cx, this);
        }
        finally {
            cx.exit();
        }
        this.indexedProps = new HashMap<Object, Object>();
        this.implementor = new InterfaceImplementor(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean isImplemented(Object thiz, Class<?> iface) {
                Context cx = RhinoScriptEngine.enterContext();
                try {
                    if (thiz != null && !(thiz instanceof Scriptable)) {
                        thiz = Context.toObject((Object)thiz, (Scriptable)RhinoScriptEngine.this.topLevel);
                    }
                    Scriptable engineScope = RhinoScriptEngine.this.getRuntimeScope(RhinoScriptEngine.this.context);
                    Scriptable localScope = thiz != null ? (Scriptable)thiz : engineScope;
                    for (Method method : iface.getMethods()) {
                        Object obj;
                        if (method.getDeclaringClass() == Object.class || (obj = ScriptableObject.getProperty((Scriptable)localScope, (String)method.getName())) instanceof Function) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    cx.exit();
                }
            }

            @Override
            protected Object convertResult(Method method, Object res) throws ScriptException {
                Class<?> desiredType = method.getReturnType();
                if (desiredType == Void.TYPE) {
                    return null;
                }
                return Context.jsToJava((Object)res, desiredType);
            }
        };
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        Object ret;
        Context cx = RhinoScriptEngine.enterContext();
        try {
            Scriptable scope = this.getRuntimeScope(ctxt);
            String filename = (String)this.get("javax.script.filename");
            filename = filename == null ? "<Unknown source>" : filename;
            ret = cx.evaluateReader(scope, reader, filename, 1, null);
        }
        catch (RhinoException re) {
            int line = re.lineNumber();
            line = line == 0 ? -1 : line;
            String msg = re instanceof JavaScriptException ? String.valueOf(((JavaScriptException)re).getValue()) : re.toString();
            ScriptException se = new ScriptException(msg, re.sourceName(), line);
            se.initCause(re);
            throw se;
        }
        catch (IOException ee) {
            throw new ScriptException(ee);
        }
        finally {
            cx.exit();
        }
        return this.unwrapReturnValue(ret);
    }

    @Override
    public Object eval(String script, ScriptContext ctxt) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("null script");
        }
        return this.eval((Reader)new StringReader(script), ctxt);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        return new RhinoScriptEngineFactory();
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invoke(null, name, args);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        return this.invoke(thiz, name, args);
    }

    private Object invoke(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Context cx = RhinoScriptEngine.enterContext();
        try {
            if (name == null) {
                throw new NullPointerException("method name is null");
            }
            if (thiz != null && !(thiz instanceof Scriptable)) {
                thiz = Context.toObject((Object)thiz, (Scriptable)this.topLevel);
            }
            Scriptable engineScope = this.getRuntimeScope(this.context);
            Scriptable localScope = thiz != null ? (Scriptable)thiz : engineScope;
            Object obj = ScriptableObject.getProperty((Scriptable)localScope, (String)name);
            if (!(obj instanceof Function)) {
                throw new NoSuchMethodException("no such method: " + name);
            }
            Function func = (Function)obj;
            Scriptable scope = func.getParentScope();
            if (scope == null) {
                scope = engineScope;
            }
            Object result = func.call(cx, scope, localScope, this.wrapArguments(args));
            Object object = this.unwrapReturnValue(result);
            return object;
        }
        catch (RhinoException re) {
            int line = re.lineNumber();
            line = line == 0 ? -1 : line;
            ScriptException se = new ScriptException(re.toString(), re.sourceName(), line);
            se.initCause(re);
            throw se;
        }
        finally {
            cx.exit();
        }
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        try {
            return this.implementor.getInterface(null, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        try {
            return this.implementor.getInterface(thiz, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Scriptable getRuntimeScope(ScriptContext ctxt) {
        if (ctxt == null) {
            throw new NullPointerException("null script context");
        }
        ExternalScriptable newScope = new ExternalScriptable(ctxt, this.indexedProps);
        newScope.setPrototype((Scriptable)this.topLevel);
        newScope.put("context", newScope, ctxt);
        Context cx = RhinoScriptEngine.enterContext();
        try {
            cx.evaluateString((Scriptable)newScope, printSource, "print", 1, null);
        }
        finally {
            cx.exit();
        }
        return newScope;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        RhinoCompiledScript ret = null;
        Context cx = RhinoScriptEngine.enterContext();
        try {
            String fileName = (String)this.get("javax.script.filename");
            if (fileName == null) {
                fileName = "<Unknown Source>";
            }
            Scriptable scope = this.getRuntimeScope(this.context);
            Script scr = cx.compileReader(scope, script, fileName, 1, null);
            ret = new RhinoCompiledScript(this, scr);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            cx.exit();
        }
        return ret;
    }

    static Context enterContext() {
        return Context.enter();
    }

    void setEngineFactory(ScriptEngineFactory fac) {
        this.factory = fac;
    }

    Object[] wrapArguments(Object[] args) {
        if (args == null) {
            return Context.emptyArgs;
        }
        Object[] res = new Object[args.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = Context.javaToJS((Object)args[i], (Scriptable)this.topLevel);
        }
        return res;
    }

    Object unwrapReturnValue(Object result) {
        if (result instanceof Wrapper) {
            result = ((Wrapper)result).unwrap();
        }
        return result instanceof Undefined ? null : result;
    }

    static {
        ContextFactory.initGlobal((ContextFactory)new ContextFactory(){

            protected Context makeContext() {
                Context cx = super.makeContext();
                cx.setLanguageVersion(languageVersion);
                cx.setOptimizationLevel(optimizationLevel);
                cx.setClassShutter(RhinoClassShutter.getInstance());
                cx.setWrapFactory(RhinoWrapFactory.getInstance());
                return cx;
            }
        });
    }
}

