/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class AuroraCookie
extends AbstractEntry {
    private String name;
    private String value;
    private int maxAge = -1;

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap mContext = runner.getContext();
        HttpServiceInstance mService = (HttpServiceInstance)ServiceInstance.getInstance(mContext);
        HttpServletResponse response = mService.getResponse();
        HttpServletRequest request = mService.getRequest();
        this.setValue(TextParser.parse(this.getValue(), mContext));
        Cookie cookie = new Cookie(this.name, this.value);
        String path = request.getContextPath();
        path = path == null || path.length() == 0 ? "/" : path;
        cookie.setPath(path);
        cookie.setMaxAge(this.maxAge);
        response.addCookie(cookie);
    }
}

