/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.quartz;

import aurora.plugin.quartz.AuroraJobDetail;
import aurora.plugin.quartz.SchedulerConfig;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import org.quartz.JobExecutionContext;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class ProcedureInvoke {
    IObjectRegistry registry = SchedulerConfig.getObjectRegistry();
    String jobName;
    String serviceName;

    public void run(JobExecutionContext context) throws Exception {
        AuroraJobDetail detail = (AuroraJobDetail)context.getJobDetail();
        CompositeMap config = detail.getConfig();
        this.jobName = config.getString((Object)"name");
        this.serviceName = config.getString((Object)"procedure");
        IProcedureManager procedureManager = (IProcedureManager)this.registry.getInstanceOfType(IProcedureManager.class);
        IServiceFactory serviceFactory = (IServiceFactory)this.registry.getInstanceOfType(IServiceFactory.class);
        Procedure proc = procedureManager.loadProcedure(this.serviceName);
        CompositeMap auroraContext = new CompositeMap();
        auroraContext.createChild("parameter").put((Object)"job_name", (Object)this.jobName);
        ServiceInvoker.invokeProcedureWithTransaction((String)this.serviceName, (Procedure)proc, (IServiceFactory)serviceFactory, (CompositeMap)auroraContext);
    }
}

